// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is part of the Rosetta software suite and is made available under license.
// The Rosetta software is developed by the contributing members of the Rosetta Commons consortium.
// (C) 199x-2009 Rosetta Commons participating institutions and developers.
// For more information, see http://www.rosettacommons.org/.

/// @file   core/scoring/ScoreFunction.hh
/// @brief  Score function class
/// @author Phil Bradley


#ifndef INCLUDED_core_scoring_methods_SymmetricLigandEnergy_HH
#define INCLUDED_core_scoring_methods_SymmetricLigandEnergy_HH

// Unit headers
#include <core/scoring/methods/SymmetricLigandEnergy.fwd.hh>

// Package headers
#include <core/scoring/methods/ContextIndependentOneBodyEnergy.hh>
#include <core/scoring/dunbrack/RotamerLibrary.fwd.hh>
#include <core/scoring/dunbrack/RotamerLibraryScratchSpace.fwd.hh>

// Project headers
#include <core/pose/Pose.fwd.hh>


namespace core {
namespace scoring {
namespace methods {

///
class SymmetricLigandEnergy : public ContextIndependentOneBodyEnergy {
public:

	/// @brief ctor
	SymmetricLigandEnergy();

	/// @brief dtor
	virtual ~SymmetricLigandEnergy();

	/// clone
	virtual
	EnergyMethodOP
	clone() const;

	/////////////////////////////////////////////////////////////////////////////
	// methods for ContextIndependentOneBodyEnergies
	/////////////////////////////////////////////////////////////////////////////

	///
	virtual
	void
	residue_energy(
		conformation::Residue const & rsd,
		EnergyMap & emap
	) const;


	virtual
	void
	eval_atom_derivative(
		id::AtomID const & id,
		pose::Pose const & pose,
		kinematics::DomainMap const & domain_map,
		ScoreFunction const & sfxn,
		EnergyMap const & emap,
		Vector & F1,
		Vector & F2
	) const;

	/// @brief SymmetricLigandEnergy is context independent; indicates that no
	/// context graphs are required
	virtual
	void indicate_required_context_graphs( utility::vector1< bool > & ) const;



};

} // methods
} // scoring
} // core


#endif // INCLUDED_core_scoring_SymmetricLigandEnergy_HH
