// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/scoring/methods/UnfoldedStateEnergy.hh
/// @brief  Unfolded state energy declaration header file
/// @author Ron Jacak (ronj@email.unc.edu)


#ifndef INCLUDED_core_scoring_methods_UnfoldedStateEnergy_HH
#define INCLUDED_core_scoring_methods_UnfoldedStateEnergy_HH

// Unit headers
#include <core/scoring/methods/UnfoldedStateEnergy.fwd.hh>

// Package headers
#include <core/scoring/EnergyMap.hh>
#include <core/scoring/methods/ContextIndependentOneBodyEnergy.hh>

#include <core/scoring/UnfoldedStatePotential.fwd.hh>

namespace core {
namespace scoring {
namespace methods {


class UnfoldedStateEnergy : public ContextIndependentOneBodyEnergy {
public:
	typedef ContextIndependentOneBodyEnergy parent;
public:

	UnfoldedStateEnergy();
	UnfoldedStateEnergy( utility::vector1< Real > const & vector_weights_in );
	UnfoldedStateEnergy( const EnergyMap & emap_in );

	virtual ~UnfoldedStateEnergy();

	virtual
	EnergyMethodOP clone() const;

	virtual
	void
	residue_energy( conformation::Residue const & rsd, EnergyMap & emap ) const;

	virtual
	Real
	eval_dof_derivative(
		id::DOF_ID const & dof_id, id::TorsionID const & tor_id, pose::Pose const & pose,
		ScoreFunction const & sfxn, EnergyMap const & weights
	) const;

	virtual
	void indicate_required_context_graphs( utility::vector1< bool > & ) const;

private:

	void
	store_weights_in_emap( utility::vector1< Real > const & v );

	UnfoldedStatePotential const & unf_state_potential_;
	EnergyMap score_type_weights_;

};

} // methods
} // scoring
} // core


#endif // INCLUDED_core_scoring_methods_UnfoldedStateEnergy_HH
