// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
// :noTabs=false:tabSize=4:indentSize=4:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file core/scoring/methods/util.cc
///
/// @brief utility methods for scoring.
/// @author James Thompson

// Unit headers
#include <core/scoring/methods/util.hh>

#include <core/options/option.hh>

#include <core/util/Tracer.hh>
#include <core/types.hh>

#include <utility/exit.hh>


// option key includes

#include <core/options/keys/abinitio.OptionKeys.gen.hh>


namespace core {
namespace scoring {
namespace methods {

static util::Tracer tr("core.scoring.methods");

	core::Real get_residue_weight_by_ss(
		const char ss
	) {

		using namespace core::options;
		using namespace core::options::OptionKeys;
		core::Real rsd_wt = 1.0;
		if ( ss == 'H' ) {
			rsd_wt = option[ abinitio::rsd_wt_helix  ]();
		} else if ( ss == 'E' ) {
			rsd_wt = option[ abinitio::rsd_wt_strand ]();
		} else if ( ss == 'L' ) {
			rsd_wt = option[ abinitio::rsd_wt_loop   ]();
		} else {
			tr.Error << "Error: don't recognize secondary structure character '" <<  ss << "' " << std::endl;
			rsd_wt = option[ abinitio::rsd_wt_loop   ]();
		}

		return rsd_wt;
	} // get_residue_wt_by_ss

} // namespace methods
} // namespace scoring
} // namespace core
