// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/scoring/ScoreFunction.hh
/// @brief  Score function class
/// @author Phil Bradley


#ifndef INCLUDED_core_scoring_sasa_HH
#define INCLUDED_core_scoring_sasa_HH

#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/id/AtomID_Map.fwd.hh>

// Utility headers
#include <utility/vector1.hh>

// C++

namespace core {
namespace scoring {


/// returns total sasa
Real
calc_per_atom_sasa(
	pose::Pose const & pose,
	id::AtomID_Map< Real > & atom_sasa,
	utility::vector1< Real > & rsd_sasa,
	Real const probe_radius,
	bool const use_big_polar_H = false
);

/// returns total sasa
Real
calc_per_atom_sasa(
	pose::Pose const & pose,
	id::AtomID_Map< Real > & atom_sasa,
	utility::vector1< Real > & rsd_sasa,
	Real const probe_radius,
	bool const use_big_polar_H,
	id::AtomID_Map< bool > & atom_subset
);

/// returns total sasa
Real
calc_total_sasa(
	pose::Pose const & pose,
	Real const probe_radius
);

} // namespace scoring
} // namespace core


#endif // INCLUDED_core_scoring_ScoreFunction_HH
