// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// This file is made available under the Rosetta Commons license.
// See http://www.rosettacommons.org/license
// (C) 199x-2007 University of Washington
// (C) 199x-2007 University of California Santa Cruz
// (C) 199x-2007 University of California San Francisco
// (C) 199x-2007 Johns Hopkins University
// (C) 199x-2007 University of North Carolina, Chapel Hill
// (C) 199x-2007 Vanderbilt University

/// @file   core/scoring/ScoreFunction.hh
/// @brief  Score function class
/// @author Phil Bradley


#ifndef INCLUDED_core_scoring_symmetry_SymmetricScoreFunction_HH
#define INCLUDED_core_scoring_symmetry_SymmetricScoreFunction_HH

#include <core/scoring/symmetry/SymmetricScoreFunction.fwd.hh>
#include <core/scoring/ScoreFunction.hh>
#include <core/conformation/symmetry/SymmetricConformation.hh>
#include <core/conformation/symmetry/SymmetricConformation.fwd.hh>
#include <core/scoring/hbonds/HBondSet.hh>

namespace core {
namespace scoring {
namespace symmetry {

class SymmetricScoreFunction : public ScoreFunction
{
public:

typedef conformation::symmetry::SymmetricConformation SymmetricConformation;
typedef conformation::symmetry::SymmetryInfo SymmetryInfo;

public:

	/// ctor
	SymmetricScoreFunction();

	SymmetricScoreFunction &
	operator=( SymmetricScoreFunction const & );

	SymmetricScoreFunction( SymmetricScoreFunction const & );

	SymmetricScoreFunction( ScoreFunction const & src );

	SymmetricScoreFunction( ScoreFunctionOP src );

	SymmetricScoreFunction( ScoreFunctionCOP src );

	ScoreFunctionOP clone() const;

  /////////////////////////////////////////////////////////////////////////////
  // score
  /////////////////////////////////////////////////////////////////////////////

	virtual Real
	operator ()( pose::Pose & pose ) const;

	///
  void
  eval_twobody_neighbor_energies( pose::Pose & pose ) const;

  void
  eval_long_range_twobody_energies( pose::Pose & pose ) const;

	///
	void
	eval_onebody_energies( pose::Pose & pose ) const;

	void
	create_intersubunit_hbonds( pose::Pose & pose,
															hbonds::HBondSetOP hbond_set_subunit ) const;

	void
	intersubunit_hbond_energy( pose::Pose & pose,
														 EnergyMap & intersubunit_energy  ) const;

	void
	symmetrical_allow_hbonds( pose::Pose & pose ) const;

	void
	set_symmetric_residue_neighbors_hbonds( pose::Pose & pose ) const;

	void
	set_symmetric_cenlist( pose::Pose & pose ) const;

	void
	correct_arrays_for_symmetry( pose::Pose & pose ) const;

	void
	correct_finalize_score( pose::Pose & pose ) const;

};


} // symmetry
} // namespace scoring
} // namespace core

#endif // INCLUDED_core_scoring_SymmetricScoreFunction_HH
