// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file MultipleSequenceAlignment.hh
/// @brief class definition for a multiple sequence alignment
/// @author James Thompson

#ifndef INCLUDED_core_sequence_MultipleSequenceAlignment_HH
#define INCLUDED_core_sequence_MultipleSequenceAlignment_HH

#include <core/types.hh>
#include <core/util/Tracer.hh>
#include <utility/vector1.hh>
#include <core/sequence/Sequence.hh>

#include <iostream>
#include <string>

namespace core {
namespace sequence {

class MultipleSequenceAlignment {

public:
	/// @brief ctor
	MultipleSequenceAlignment() : score_(0) {}

	/// @brief dtor
	~MultipleSequenceAlignment() {}

	/// @brief copy
	MultipleSequenceAlignment & operator = ( MultipleSequenceAlignment const & rhs ) {
		score_ = rhs.score();
		sequences_ = rhs.sequences();
		return *this;
	}

	void remove_gapped_columns();

	utility::vector1< Sequence > sequences() const {
		return sequences_;
	}

	void add_sequence( Sequence myseq );
	core::Size size() const;

	void alignment_from_file( std::string const & filename );
	// void read_alignment( std::istream & input );  // Undefinded function, commenting out to make Python binding compile

	Sequence sequence( core::Size idx ) {
		runtime_assert( idx <= sequences_.size() );
		return sequences_[ idx ];
	}

	void insert_gap_into_sequence( core::Size sequence_index, core::Size position );

	friend std::ostream & operator<<( std::ostream & out, const MultipleSequenceAlignment & msa ) {
		out << "score: " << msa.score()
				//<< " identities: " << msa.identities() << "/" << msa.sequences()[1].length()
				<< std::endl;
		// calculate percent identity

		for ( core::Size i = 1; i <= msa.size(); ++i ) {
			out << msa.sequences()[i] << std::endl;
		}
		return out;
	}

	core::Real score() const {
		return score_;
	}

	void score( core::Real const score ) {
		score_ = score;
	}

private:
	core::Real score_;
	utility::vector1< Sequence > sequences_;
}; // class MultipleSequenceAlignment

// bool MSA_less_than( MultipleSequenceAlignment msa1, MultipleSequenceAlignment msa2 ) {
// 	return ( msa1.score() < msa2.score() );
// }

} // sequence
} // core

#endif
