// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/util/datacache/BasicDataCache.hh
/// @brief  A DataCache storing objects derived from
///         core::util::datacache::CacheableData.
/// @author Yih-En Andrew Ban (yab@u.washington.edu)

#ifndef INCLUDED_core_util_datacache_BasicDataCache_HH
#define INCLUDED_core_util_datacache_BasicDataCache_HH

// unit headers
#include <core/util/datacache/BasicDataCache.fwd.hh>

// package headers
#include <core/util/datacache/CacheableData.hh>
#include <core/util/datacache/DataCache.hh>


namespace core {
namespace util {
namespace datacache {


/// @brief A DataCache storing objects derived from
///  core::util::datacache::CacheableData.
/// @details See DataCache base class for usage details.
class BasicDataCache : public DataCache< CacheableData > {


private: // typedefs


	typedef DataCache< CacheableData > Super;


public: // typedefs


	typedef Super::Size Size;


public: // construct/destruct


	/// @brief default constructor
	BasicDataCache();


	/// @brief size constructor
	/// @param[in] n_types The number of slots for this DataCache.
	BasicDataCache( Size const n_slots );


	/// @brief copy constructor
	BasicDataCache( BasicDataCache const & rval );


	/// @brief default destructor
	virtual
	~BasicDataCache();


public: // assignment


	/// @brief copy assignment
	BasicDataCache & operator =( BasicDataCache const & rval );


};


} // namespace datacache
} // namespace util
} // namespace core


#endif /* INCLUDED_core_util_datacache_BasicDataCache_HH */
