// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/util/datacache/DiagnosticData.hh
/// @brief
/// @author Phil Bradley


#ifndef INCLUDED_core_util_datacache_DiagnosticData_HH
#define INCLUDED_core_util_datacache_DiagnosticData_HH

// unit headers
#include <core/util/datacache/DiagnosticData.fwd.hh>

// type headers
#include <core/types.hh>

// package headers
#include <core/util/datacache/CacheableData.hh>

// C++ headers
#include <string>


namespace core {
namespace util {
namespace datacache {


///@brief Wrapper for std::map<string, Real>
class DiagnosticData : public CacheableData
{
public:
	DiagnosticData( std::map < std::string, core::Real >  data_in ) : CacheableData(), data_(data_in) {}
	virtual ~DiagnosticData(){};
	virtual CacheableDataOP clone() const { return new DiagnosticData(*this); }
	virtual std::map < std::string, core::Real > const & data() const { return data_; }
private:
	std::map < std::string, core::Real > data_;
};


} // namespace datacache
} // namespace util
} // namespace core

#endif /* INCLUDED_core_util_datacache_DiagnosticData_HH */
