// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   core/util/datacache/cacheable_observers.hh
/// @brief  file that has class definitions for a bunch of general CacheableObserver implementations
///
/// @author Florian Richter (floric@u.washington.edu)

#ifndef INCLUDED_core_util_datacache_cacheable_observers_HH
#define INCLUDED_core_util_datacache_cacheable_observers_HH

// unit headers
#include <core/util/datacache/cacheable_observers.fwd.hh>
#include <core/pose/datacache/CacheableObserver.hh>

// project headers
#include <core/conformation/signals/LengthEvent.hh>
//#include <core/pose/Pose.fwd.hh>

// utility headers
#include <utility/vector1.hh>
//#include <utility/pointer/ReferenceCount.hh>
#include <utility/signals/Link.hh>


namespace core {
namespace util {
namespace datacache {


/// @brief a cacheable observer that keeps track of what length events occured
class LengthEventCollector : public core::pose::datacache::CacheableObserver {


public: // typedefs


	typedef utility::signals::Link Link;


public: // construct/destruct


	/// @brief default constructor
	LengthEventCollector();


	/// @brief copy constructor
	/// @warning Subject being observed (represented by Link/pointer) is not copied!
	LengthEventCollector( LengthEventCollector const & rval );


	/// @brief default destructor
	/// @remarks detaches during destruction
	//virtual
	~LengthEventCollector();


public: // assignment


	/// @brief copy assignment
	/// @warning Subject being observed (represented by Link/pointer) is not copied!
	LengthEventCollector & operator =( LengthEventCollector const & rval );


public: // virtual constructors


	/// @brief clone this object
	/// @warning Subject (represented by Link/pointer) is not copied!
	pose::datacache::CacheableObserverOP clone();


	/// @brief create a new instance of this object
	pose::datacache::CacheableObserverOP create();


public: // interface


	/// @brief is this observer attached to a Pose/Conformation?
	bool is_attached() const {
		return length_event_link_.valid(); }

	void
	clear_events(){
		length_events_.clear(); }

	utility::vector1< core::conformation::signals::LengthEvent > const &
	events();


protected: // virtual observer interface


	/// @brief attach to Pose/Conformation
	virtual
	void attach_impl( pose::Pose & pose );


	/// @brief detach from Pose/Conformation
	virtual
	void detach_impl();

	void
	on_length_change( conformation::signals::LengthEvent const & event );

	//data
private:

	void
	copy_length_events( utility::vector1< core::conformation::signals::LengthEvent > const & events );

	utility::vector1< core::conformation::signals::LengthEvent > length_events_;

	Link length_event_link_;

};


} // namespace datacache
} // namespace pose
} // namespace core


#endif /* INCLUDED_core_pose_datacache_CacheableObserver_HH */
