// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   integration/make_Protein.hh
/// @brief  Create a Protein object from "classic" Rosetta data structures
/// @author Stuart G. Mentzer (Stuart_Mentzer@objexx.com)

// libRosetta headers
#include <core/conformation/Protein.fwd.hh>


namespace integration {


/// @brief Create a Protein object from "classic" Rosetta data structures
core::conformation::ProteinOP
make_Protein(
	int const res_beg, // First residue in protein
	int const res_end  // Last residue in protein
);


} // namespace integration
