// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file devel/ProteinInterfaceDesign/DockDesign.hh
/// @author Sarel Fleishman (sarelf@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_DockDesign_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_DockDesign_HH

// Project Headers
#include <core/pose/Pose.fwd.hh>
#include <protocols/moves/Mover.fwd.hh>
#include <protocols/moves/OutputMovers.hh>

#include <core/types.hh>
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <utility/pointer/ReferenceCount.hh>
#include <protocols/filters/Filter.hh>

// C++ headers
#include <string>

// Unit headers
#include <protocols/ProteinInterfaceDesign/DockDesign.fwd.hh>

namespace protocols {
namespace ProteinInterfaceDesign {

class DockDesign : public protocols::moves::Mover
{
public:
	typedef core::Real Real;
	typedef core::pose::Pose Pose;
	typedef std::pair< protocols::moves::MoverOP, protocols::filters::FilterCOP > mover_filter_pair;
public:
	DockDesign() : protocols::moves::Mover( "DockDesign" ) { }
	DockDesign( DockDesign const & init ) : protocols::moves::Mover( init ), movers_( init.movers_ ) {}
	void apply( Pose & pose );
	void add_mover( protocols::moves::MoverCOP mover, protocols::filters::FilterCOP filter ) {
		protocols::moves::MoverOP mover_p = dynamic_cast< protocols::moves::Mover * >(mover->clone()()); //cast can go away if MoverOP is used
		protocols::filters::FilterCOP filter_p = filter->clone();
		mover_filter_pair p( mover_p, filter_p );
		movers_.push_back( p );
	}
	void report_all( Pose const & pose ) const; // cycles over all filter->report methods to output their values to a common stream.
	void report_all_sm( std::map< std::string, core::Real > & score_map, Pose const & pose ) const; // ditto, but outputs filter values into score_map object
	protocols::moves::MoverCOP get_mover( core::Size const mover_number ) const {
		runtime_assert( movers_.size() >= mover_number && mover_number > 0 );
		return( movers_[ mover_number ].first );
	}
	protocols::moves::MoverOP clone() const { return protocols::moves::MoverOP( new DockDesign( *this ) ); }
	protocols::moves::MoverOP fresh_instance() const { return protocols::moves::MoverOP( new DockDesign ); }
	virtual void parse_my_tag( utility::Tag::TagPtr const, protocols::moves::DataMap &, protocols::filters::Filters_map const &, protocols::moves::Movers_map const &, core::pose::Pose const & ); // this is defined as public here, b/c I need to circumvent the name-check, since this is called both by the Movers section (as DockDesign) and the PROTOCOLS section.
	void clear() { movers_.clear(); }
	virtual ~DockDesign(){};
private:
	utility::vector1< mover_filter_pair > movers_;
};

} // ProteinInterfaceDesign
} // devel

#endif /*INCLUDED_protocols_ProteinInterfaceDesign_DockDesign_HH*/
