// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/jd2/PDBJobInputter.cc
/// @brief  August 2008 job distributor as planned at RosettaCon08 - Base class PDBJobInputter
/// @author Steven Lewis smlewi@gmail.com

///Unit headers
#include <protocols/ProteinInterfaceDesign/ParserJobInputter.hh>
#include <protocols/ProteinInterfaceDesign/read_patchdock.hh>
#include <protocols/jd2/Job.hh>

///Project headers
#include <protocols/jobdist/Jobs.hh>

#include <core/io/pdb/pose_io.hh>
#include <core/pose/Pose.hh>

#ifdef WIN32
// required for VS2005 build
#include <core/conformation/Residue.hh>
#endif

///Utility headers
#include <core/util/Tracer.hh>
#include <core/options/option.hh>
#include <core/options/util.hh>
#include <utility/vector1.hh>

///C++ headers
#include <string>

// option key includes
#include <core/options/keys/out.OptionKeys.gen.hh>
#include <core/options/keys/in.OptionKeys.gen.hh>

static core::util::Tracer TR("protocols.ProteinInterfaceDesign.ParserJobInputter");

namespace protocols {
namespace jd2 {

protocols::jd2::ParserJobInputter::ParserJobInputter(){
	TR << "Instantiate ParserJobInputter" << std::endl;
}

protocols::jd2::ParserJobInputter::~ParserJobInputter(){}

///@details This function will first see if the pose already exists in the Job.  If not, it will read it into the pose reference, and hand a COP cloned from that pose to the Job. If the pose pre-exists it just copies the COP's pose into it.
void protocols::jd2::ParserJobInputter::pose_from_job( core::pose::Pose & pose, JobOP job){
	TR << "ParserJobInputter::pose_from_job" << std::endl;

	if( !job->inner_job()->get_pose() ){
		std::string input_tag( job->inner_job()->input_tag() );
		protocols::ProteinInterfaceDesign::read_poses( pose, input_tag );
		load_pose_into_job(pose, job);
		TR << "filling pose from PDB " << input_tag << std::endl;
	} else {
		pose = *(job->inner_job()->get_pose());
		TR << "filling pose from saved copy " << job->inner_job()->input_tag() << std::endl;
	}
}

}//jd2
}//protocols
