// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/BuildAlaPose.cc
/// @brief
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

#include <protocols/ProteinInterfaceDesign/movers/BuildAlaPose.hh>
#include <protocols/ProteinInterfaceDesign/movers/IDMover_cc_headers.hh>

#include <core/pose/Pose.hh>
#include <core/conformation/Conformation.hh>
#include <core/pack/pack_rotamers.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

using namespace core;
using namespace std;
using namespace core::scoring;
using namespace protocols::moves;

static core::util::Tracer TR( "protocols.ProteinInterfaceDesign.movers.BuildAlaPose" );

void
BuildAlaPose::apply( pose::Pose & pose )
{
	using namespace core::scoring;

	allowed_aas_.assign( core::chemical::num_canonical_aas, false );
	allowed_aas_[ core::chemical::aa_ala ] = true;
	if( repack_partner1_ ^ repack_partner2_ ){
		bool const prevent_chain1( !repack_partner1_ );
		bool const prevent_chain2( !repack_partner2_ );
		core::Size const prevent_chain_begin( pose.conformation().chain_begin( prevent_chain1 ? 1 : 2 ) );
		core::Size const prevent_chain_end( pose.conformation().chain_end( prevent_chain2 ? 2 : 1 ) );
		for( core::Size res=prevent_chain_begin; res<=prevent_chain_end; ++res )
			prevent_repacking_.push_back( res );
	}
	setup_packer_and_movemap( pose );

	core::scoring::ScoreFunctionOP scorefxn( ScoreFunctionFactory::create_score_function( STANDARD_WTS, SCORE12_PATCH ) );
	pack::pack_rotamers( pose, *scorefxn, task_ );
	(*scorefxn)( pose );
	/// Now handled automatically.  scorefxn->accumulate_residue_total_energies( pose );
}


void
BuildAlaPose::parse_my_tag( TagPtr const tag, DataMap &, protocols::filters::Filters_map const &, Movers_map const &, core::pose::Pose const & )
{
	repack_partner1_ = tag->getOption<bool>( "partner1", 0 );
	repack_partner2_ = tag->getOption<bool>( "partner2", 1 );
	interface_distance_cutoff_ = tag->getOption<core::Real>( "interface_cutoff_distance", 8.0 );

	TR<<"defined BuildAlaPose mover "<<" for partners "<<( repack_partner1_ ? "1" : "" )<<( repack_partner2_ ? "2": "" )<<" with distance cutoff "<<
		interface_distance_cutoff_<<std::endl;
}

} //movers
} //ProteinInterfaceDesign
} //protocols
