// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.


/// @file protocols/ProteinInterfaceDesign/movers/DockAndRetrieveSidechains.cc
/// @brief
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

#include <protocols/ProteinInterfaceDesign/movers/DockAndRetrieveSidechains.hh>
#include <protocols/ProteinInterfaceDesign/movers/IDMover_cc_headers.hh>
#include <protocols/moves/ReturnSidechainMover.hh>

#include <protocols/moves/SwitchResidueTypeSetMover.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

using namespace core;
using namespace std;
using namespace core::scoring;
using namespace protocols::moves;

static core::util::Tracer TR( "protocols.ProteinInterfaceDesign.movers.DockAndRetrieveSidechains" );

void
DockAndRetrieveSidechains::apply( core::pose::Pose & pose )
{
	core::pose::PoseCOP saved_pose = new core::pose::Pose( pose );
	docking_mover_->set_native_pose( saved_pose );
	docking_mover_->set_input_pose( saved_pose );

	docking_mover_->apply( pose );
	if( !fullatom_ ) {
		protocols::moves::SwitchResidueTypeSetMover to_all_atom( chemical::FA_STANDARD );
		protocols::moves::ReturnSidechainMover recover_sidechains( *saved_pose );
		to_all_atom.apply( pose );
		recover_sidechains.apply( pose );
		pose.update_residue_neighbors();
	}
}


void
DockAndRetrieveSidechains::parse_my_tag( TagPtr const tag, DataMap & data, protocols::filters::Filters_map const &, Movers_map const &, core::pose::Pose const & )
{
	std::string const score_low( tag->getOption<string>( "score_low", "score_docking_low" ) );
	std::string const score_high( tag->getOption<string>( "score_high", "score_docking" ) );
	fullatom_ = tag->getOption< bool >( "fullatom", 0 );
	bool const local_refine( tag->getOption<bool>( "local_refine", 0 ));
	bool const view( tag->getOption<bool>( "view", 0 ) );

	using namespace core::scoring;
	ScoreFunctionCOP scorelo = new ScoreFunction( *data.get< ScoreFunction * >( "scorefxns", score_low ) );
	ScoreFunctionCOP scorehi = new ScoreFunction( *data.get< ScoreFunction * >( "scorefxns", score_high ));

	core::Size const rb_jump( tag->getOption< core::Size >( "rb_jump", 1 ) );
	bool const optimize_foldtree = tag->getOption<bool>( "optimize_fold_tree", 1 );
	docking_mover_ = new protocols::docking::DockingProtocol( rb_jump, fullatom_, local_refine, view, scorelo, scorehi, optimize_foldtree );

	TR<<"docking mover with parameters fullatom "<<fullatom_<<" local_refine "<<local_refine<<" view "<<view<< "  lowres_scorefxn= " << score_low <<
		"  highres_scorefxn= " << score_high<<" over rb_jump "<<rb_jump<<" optimize fold tree="<<optimize_foldtree<<std::endl;
}


} //movers
} //ProteinInterfaceDesign
} //protocols

