// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/DockAndRetrieveSidechains.hh
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_DockAndRetrieveSidechains_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_DockAndRetrieveSidechains_HH

#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/filters/Filter.fwd.hh>
#include <protocols/moves/Mover.hh>
#include <core/scoring/ScoreFunction.fwd.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <protocols/docking/DockingProtocol.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

class DockAndRetrieveSidechains : public protocols::moves::Mover
{
public:
	DockAndRetrieveSidechains() : protocols::moves::Mover( "Docking" ) {}
	DockAndRetrieveSidechains( core::Size const rb_jump_in, bool const fullatom, bool const local_refine,
							   bool const view, core::scoring::ScoreFunctionOP score_low, core::scoring::ScoreFunctionOP score_high ) : protocols::moves::Mover( "Docking" ) {
		core::scoring::ScoreFunctionCOP dock_score_low( *score_low );
		core::scoring::ScoreFunctionCOP dock_score_high( *score_high );
		docking_mover_ = new protocols::docking::DockingProtocol( rb_jump_in, fullatom, local_refine, view, dock_score_low, dock_score_high );
		fullatom_ = fullatom;
	}
	DockAndRetrieveSidechains( DockAndRetrieveSidechains const & init ) : protocols::moves::Mover( init ) { // copy constructor
		docking_mover_ = new protocols::docking::DockingProtocol( *(init.docking_mover_ ) );
		fullatom_ = init.fullatom_;
	}
	protocols::moves::MoverOP clone() const {
		return( protocols::moves::MoverOP( new DockAndRetrieveSidechains( *this ) ) );
	}
	protocols::moves::MoverOP fresh_instance() const { return protocols::moves::MoverOP( new DockAndRetrieveSidechains ); }
	void apply( core::pose::Pose & pose );
	void parse_my_tag( utility::Tag::TagPtr const tag, protocols::moves::DataMap &, protocols::filters::Filters_map const &, protocols::moves::Movers_map const &, core::pose::Pose const & );
	virtual ~DockAndRetrieveSidechains() {};
private:
	protocols::docking::DockingProtocolOP docking_mover_;
	bool fullatom_;
};

} // movers
} // ProteinInterfaceDesign
} // protocols


#endif /*INCLUDED_protocols_ProteinInterfaceDesign_movers_DockAndRetrieveSidechains_HH*/

