// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/FavorNativeResiduePreCycle.hh
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_FavorNativeResiduePreCycle_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_FavorNativeResiduePreCycle_HH

#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/filters/Filter.fwd.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <protocols/ProteinInterfaceDesign/design_utils.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

class FavorNativeResiduePreCycle : public protocols::moves::Mover
{
public:
	FavorNativeResiduePreCycle( core::Real const bonus = 1.5 ) : protocols::moves::Mover( "favor_native_residue" ), bonus_( bonus ) {
		runtime_assert( bonus_ >= 0 );
	}
	void apply( core::pose::Pose & pose ) {
		FavorNativeResidue fnr( pose, bonus_ );
	}
	protocols::moves::MoverOP clone() const {
		return( protocols::moves::MoverOP( new FavorNativeResiduePreCycle( bonus_ ) ) );
	}
	protocols::moves::MoverOP fresh_instance() const { return protocols::moves::MoverOP( new FavorNativeResiduePreCycle); }
	void parse_my_tag( utility::Tag::TagPtr const tag, protocols::moves::DataMap &, protocols::filters::Filters_map const &, protocols::moves::Movers_map const &, core::pose::Pose const & );
	virtual ~FavorNativeResiduePreCycle() {};
private:
	core::Real bonus_;
};

} // movers
} // ProteinInterfaceDesign
} // protocols


#endif /*INCLUDED_protocols_ProteinInterfaceDesign_movers_FavorNativeResiduePreCycle_HH*/

