// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/HotspotHasherMover.hh
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_HotspotHasherMover_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_HotspotHasherMover_HH

#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/filters/Filter.fwd.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <core/scoring/ScoreFunction.fwd.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

class HotspotHasherMover : public protocols::moves::Mover
{
public:
	HotspotHasherMover() : protocols::moves::Mover( "HotspotHasher" ) { }
	HotspotHasherMover( std::vector<std::string> const resnames,
			core::scoring::ScoreFunctionCOP scorefxn,
			core::Size const n_stubs,
			core::Size const target_resnum,
			protocols::filters::FilterOP hotspot_filter,
			core::Real const target_distance,
			std::string const hashin_fname,
			std::string const hashout_fname ) :
		protocols::moves::Mover( "HotspotHasher" ),
		scorefxn_(scorefxn),
		resnames_(resnames),
		n_stubs_(n_stubs),
		target_resnum_(target_resnum),
		target_distance_(target_distance),
		hashin_fname_(hashin_fname),
		hashout_fname_(hashout_fname)
	{
		hotspot_filter_ = hotspot_filter;
	}
	protocols::moves::MoverOP clone() const {
		return( protocols::moves::MoverOP( new HotspotHasherMover( *this ) ) );
	}
	void apply( core::pose::Pose & pose );
	protocols::moves::MoverOP fresh_instance() const { return protocols::moves::MoverOP( new HotspotHasherMover ); }
	void parse_my_tag( utility::Tag::TagPtr const tag, protocols::moves::DataMap &, protocols::filters::Filters_map const &, protocols::moves::Movers_map const &, core::pose::Pose const & );
	virtual ~HotspotHasherMover() {};
private:
	// SET VARIABLES BASED ON THE COMMAND LINE
	// Residues to use for hashing (defaults to all, sans Gly, Cys, or Pro)
	core::scoring::ScoreFunctionCOP scorefxn_;
	std::vector< std::string > resnames_;
	core::Size n_stubs_, target_resnum_;
	core::Real target_distance_, score_threshold_;
	std::string hashin_fname_, hashout_fname_;
	protocols::filters::FilterOP hotspot_filter_; // a filter for each hotspot. defaults to TrueFilter
};


} // movers
} // ProteinInterfaceDesign
} // protocols


#endif /*INCLUDED_protocols_ProteinInterfaceDesign_movers_HotspotHasherMover_HH*/

