// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/IDMover_cc_headers.hh
/// @brief All the include statements from dock_design_movers.cc and parse_movers.cc
/// @note DO NOT ADD TO THIS FILE
/// @details
/// This file was created to ease the refactor from dock_design_movers.cc
/// to multiple mover files. The intent is that each mover have only the
/// \#includes which it requires, but sorting these out is too much work.
/// Until I have time, I'll just include this huge header.
///
/// This file should be deleted before the next release.
/// @date Created May 28, 2009
/// @author Spencer Bliven <blivens@u.washington.edu>

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_IDMover_cc_headers_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_IDMover_cc_headers_HH

////////////////////////////////
// From dock_design_movers.cc //
////////////////////////////////

// Project Headers
#include <core/types.hh>
#include <core/pose/Pose.hh>
#include <utility/Tag/Tag.hh>

#include <core/scoring/ScoreFunction.hh>
#include <core/scoring/ScoreFunctionFactory.hh>
#include <core/scoring/ScoreTypeManager.hh>
#include <core/scoring/ScoreType.hh>

#include <protocols/moves/Mover.hh>
#include <core/chemical/ChemicalManager.hh>
#include <core/chemical/ResidueType.hh>

#include <numeric/random/random.hh>

#include <core/chemical/util.hh>
// Utility Headers

// Unit Headers
#include <protocols/filters/Filter.hh>
#include <protocols/ProteinInterfaceDesign/dock_design_filters.hh>
#include <protocols/ProteinInterfaceDesign/util.hh>

// C++ headers
#include <map>
#include <algorithm>
// Project Headers
#include <core/types.hh>
#include <core/pose/PDBInfo.hh>

#include <utility/exit.hh>
#include <utility/pointer/ReferenceCount.hh>

// Unit Headers
#include <protocols/moves/DataMap.hh>

// C++ headers
#include <string>


#include <protocols/ProteinInterfaceDesign/movers/DesignRepackMover.hh>

#endif //INCLUDED_protocols_ProteinInterfaceDesign_movers_IDMover_cc_headers_HH

