// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/InterfaceRecapitulationMover.hh
/// @author Sarel Fleishman (sarelf@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_InterfaceRecapitulationMover_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_InterfaceRecapitulationMover_HH

// Project Headers
#include <core/pose/Pose.fwd.hh>
#include <protocols/moves/Mover.fwd.hh>
#include <protocols/ProteinInterfaceDesign/movers/DesignRepackMover.fwd.hh>

#include <core/types.hh>
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <protocols/filters/Filter.fwd.hh>

// C++ headers
#include <string>

// Unit headers

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

/// @brief a pure virtual base class for movers which redesign and repack the interface
class InterfaceRecapitulationMover : public protocols::moves::Mover
{
public:
	InterfaceRecapitulationMover() : protocols::moves::Mover( "InterfaceRecapitulation" ){}
	InterfaceRecapitulationMover( InterfaceRecapitulationMover const & init ) :
		protocols::moves::Mover( init ),
		design_mover_( init.design_mover_ )
	{}
	void apply( core::pose::Pose & pose );
	protocols::moves::MoverOP clone() const { return protocols::moves::MoverOP( new InterfaceRecapitulationMover( *this ) ); }
	protocols::moves::MoverOP fresh_instance() const { return protocols::moves::MoverOP( new InterfaceRecapitulationMover() ); }
	virtual void parse_my_tag( utility::Tag::TagPtr const, protocols::moves::DataMap &, protocols::filters::Filters_map const &, protocols::moves::Movers_map const &, core::pose::Pose const & );
	virtual ~InterfaceRecapitulationMover() {};
private:
	DesignRepackMoverOP design_mover_;
};

} // movers
} // ProteinInterfaceDesign
} // protocols

#endif /*INCLUDED_protocols_ProteinInterfaceDesign_movers_InterfaceRecapitulationMover_HH*/

