// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/LoopOver.cc
/// @brief
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

#include <protocols/ProteinInterfaceDesign/movers/LoopOver.hh>
#include <protocols/ProteinInterfaceDesign/movers/IDMover_cc_headers.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

using namespace core;
using namespace std;
using namespace core::scoring;
using namespace protocols::moves;

static core::util::Tracer TR( "protocols.ProteinInterfaceDesign.movers.LoopOver" );

void
LoopOver::apply( core::pose::Pose & pose )
{
	core::Size count( 0 );

//	core::pose::Pose const saved_pose = pose;

	// clear out any existing info (from prior LoopOver::apply calls)
	info().clear();

	do {
//		pose = saved_pose; // to prevent drift
		TR<<"Loop iteration "<<count<<std::endl;
		// clear out any existing info (from prior mover_->apply calls)
		mover_->info().clear();
		mover_->apply( pose );
		// inherit Mover info: jd2 JobDistributor passes this info to Job,
		// and JobOutputters may then write this info to output files
		info().insert( info().end(), mover_->info().begin(), mover_->info().end() );
		++count;
	} while( !condition_->apply( pose ) && count < max_iterations_ );
}

void
LoopOver::parse_my_tag( TagPtr const tag, protocols::moves::DataMap &, protocols::filters::Filters_map const &filters, protocols::moves::Movers_map const &movers, core::pose::Pose const & )
{
	TR<<"loop\n";
	std::string const mover_name( tag->getOption< std::string >( "mover_name" ));
	std::string const filter_name( tag->getOption< std::string >( "filter_name", "false_filter" ) );
	max_iterations_ = tag->getOption< core::Size >( "iterations", 10 );

	std::map< std::string const, MoverOP >::const_iterator find_mover( movers.find( mover_name ) );
	std::map< std::string const, protocols::filters::FilterCOP >::const_iterator find_filter( filters.find( filter_name ));
	if( find_mover == movers.end() ) {
		TR<<"WARNING WARNING!!! mover not found in map. skipping:\n"<<tag<<std::endl;
		runtime_assert( find_mover != movers.end() );
	}
	if( find_filter == filters.end() ) {
		TR<<"WARNING WARNING!!! filter not found in map. skipping:\n"<<tag<<std::endl;
		runtime_assert( find_filter == filters.end() );
	}
	mover_ = find_mover->second; // no cloning to allow other movers to change this mover at their parse time
	condition_ = find_filter->second->clone();
	TR << "with mover \"" << mover_name << "\" and filter \"" << filter_name << "\" and  " << max_iterations_<< " max iterations\n";
	TR.flush();
}


} //movers
} //ProteinInterfaceDesign
} //protocols

