// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/LoopOver.hh
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_LoopOver_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_LoopOver_HH

#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/filters/Filter.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/DataMap.fwd.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

/// @brief essentially the same as the WhileMover but allows parsing and cloning. Will be removed at a future point.
/// This should now be incorporated into WhileMover
class LoopOver : public protocols::moves::Mover
{
public:
	LoopOver() : protocols::moves::Mover( "LoopOver" ) {}
	LoopOver( core::Size max_iterations, protocols::moves::MoverCOP mover, protocols::filters::FilterCOP condition ) : protocols::moves::Mover( "Loop" ), max_iterations_( max_iterations), mover_( mover->clone() ), condition_( condition->clone() ) {}
	protocols::moves::MoverOP clone() const {
		return protocols::moves::MoverOP( new LoopOver( *this ) );
	}
	protocols::moves::MoverOP fresh_instance() const { return protocols::moves::MoverOP( new LoopOver ); }
	void apply( core::pose::Pose & pose );
	void parse_my_tag( utility::Tag::TagPtr const tag, protocols::moves::DataMap &, protocols::filters::Filters_map const &, protocols::moves::Movers_map const &, core::pose::Pose const & );
	virtual ~LoopOver() {};
private:
	core::Size max_iterations_;
	protocols::moves::MoverOP mover_;
	protocols::filters::FilterOP condition_;
};

} // movers
} // ProteinInterfaceDesign
} // protocols


#endif /*INCLUDED_protocols_ProteinInterfaceDesign_movers_LoopOver_HH*/
