// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/PeptideStapleDesignMover.hh
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_PeptideStapleDesignMover_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_PeptideStapleDesignMover_HH

#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/filters/Filter.fwd.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <protocols/moves/PeptideStapleMover.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

/// @brief Introduces a peptide staple (ala G. Verdine) to the pose.
class PeptideStapleDesignMover : public protocols::moves::Mover
{
public:
	PeptideStapleDesignMover() : protocols::moves::Mover( "StapleMover" ) {}
	PeptideStapleDesignMover( core::Size const seqpos, core::Size const staple_gap ) : protocols::moves::Mover( "StapleMover" ) {
		stapler_ = new protocols::moves::PeptideStapleMover( seqpos, staple_gap );
	}

	PeptideStapleDesignMover( PeptideStapleDesignMover const & init ) : protocols::moves::Mover( init ) { //copy c'tor
		stapler_ = new protocols::moves::PeptideStapleMover( *(init.stapler_) );
	}

	protocols::moves::MoverOP clone() const {
		return( protocols::moves::MoverOP( new PeptideStapleDesignMover( *this ) ));
	}
	void apply( core::pose::Pose & pose );
	protocols::moves::MoverOP fresh_instance() const { return protocols::moves::MoverOP( new PeptideStapleDesignMover ); }
	void parse_my_tag( utility::Tag::TagPtr const tag, protocols::moves::DataMap &, protocols::filters::Filters_map const &, protocols::moves::Movers_map const &, core::pose::Pose const & );
	virtual ~PeptideStapleDesignMover() {};
private:
	protocols::moves::PeptideStapleMoverOP stapler_;
};

} // movers
} // ProteinInterfaceDesign
} // protocols


#endif /*INCLUDED_protocols_ProteinInterfaceDesign_movers_PeptideStapleDesignMover_HH*/
