// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/SaveAndRetrieveSidechains.cc
/// @brief
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

#include <protocols/ProteinInterfaceDesign/movers/SaveAndRetrieveSidechains.hh>
#include <protocols/ProteinInterfaceDesign/movers/IDMover_cc_headers.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

using namespace core;
using namespace std;
using namespace core::scoring;
using namespace protocols::moves;

static core::util::Tracer TR( "protocols.ProteinInterfaceDesign.movers.SaveAndRetrieveSidechains" );

void
SaveAndRetrieveSidechains::apply( Pose & pose )
{
	typedef conformation::Residue Residue;
	TR << "Retrieving sidechains...\n";
	runtime_assert( pose.total_residue() == init_pose_->total_residue() );
	kinematics::Jump new_jump;
	core::Size const rb_jump( 1 );
	new_jump = pose.jump( rb_jump );
	for( core::Size res=1; res<=pose.total_residue(); ++res ) {
		if( allsc_ ) { // replace all sidechains
			pose.replace_residue( res, init_pose_->residue( res ), true/*orient_backbone*/ );
			continue;
		}
		else {
			if( pose.residue( res ).name3() == "ALA" ) // only replace Ala positions
			pose.replace_residue( res, init_pose_->residue( res ), true/*orient_backbone*/ );
		}
	}
	pose.set_jump( rb_jump, new_jump );
	TR.flush();
}

void
SaveAndRetrieveSidechains::parse_my_tag( TagPtr const tag, DataMap &, protocols::filters::Filters_map const &, Movers_map const &, core::pose::Pose const & pose )
{
	init_pose_ = new core::pose::Pose( pose );
	allsc_ = tag->getOption<bool>( "allsc", 0 );
}


} //movers
} //ProteinInterfaceDesign
} //protocols
