// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/SaveAndRetrieveSidechains.hh
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_SaveAndRetrieveSidechains_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_SaveAndRetrieveSidechains_HH

#include <core/types.hh>
#include <core/pose/Pose.hh>
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/filters/Filter.fwd.hh>
#include <protocols/moves/Mover.fwd.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <protocols/ProteinInterfaceDesign/movers/DesignRepackMover.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {


/// @brief saves a pose and reapplies its sequence and rotamers at a later stage.
/// The constructor saves the initial pose, and then any calls to apply replace the residues on the input pose with
/// that saved pose. Notice, that only ALA positions will be replaced, so this is meant to work strictly along with
/// BuildAlaPose moves. This way, if in the design process an interface residue is designed, that will not be reverted
/// to w/t
class SaveAndRetrieveSidechains : public DesignRepackMover
{
public:
	typedef core::pose::Pose Pose;
	typedef core::pose::PoseOP PoseOP;
public:
	SaveAndRetrieveSidechains() : DesignRepackMover( "SaveAndRetrieveSidechains" ) {
		allsc_ = false; // default
	}
	SaveAndRetrieveSidechains( core::pose::Pose const & pose, bool const allsc=false ) :
		DesignRepackMover( "SaveAndRetrieveSidechains" ),
		allsc_( allsc )
	{
		init_pose_ = new core::pose::Pose( pose );
	};
	SaveAndRetrieveSidechains( SaveAndRetrieveSidechains const & init ) :
		DesignRepackMover( init ),
		allsc_( init.allsc_ )
	{// copy constructor
		init_pose_ = new Pose( *(init.init_pose_) );
	}
	bool allsc() const { return allsc_; }
	void allsc( bool const allsc ) { allsc_ = allsc; }
	void apply( Pose & pose );
	protocols::moves::MoverOP clone() const {
		return( protocols::moves::MoverOP( new SaveAndRetrieveSidechains( *this )  ));
	}
	protocols::moves::MoverOP fresh_instance() const { return protocols::moves::MoverOP( new SaveAndRetrieveSidechains ); }
	void parse_my_tag( utility::Tag::TagPtr const tag, protocols::moves::DataMap &, protocols::filters::Filters_map const &, protocols::moves::Movers_map const &, core::pose::Pose const & );
	virtual ~SaveAndRetrieveSidechains() {};
private:
	PoseOP init_pose_;
	bool allsc_;
};

} // movers
} // ProteinInterfaceDesign
} // protocols


#endif /*INCLUDED_protocols_ProteinInterfaceDesign_movers_SaveAndRetrieveSidechains_HH*/
