// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/SetAtomTree.cc
/// @brief
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

#include <protocols/ProteinInterfaceDesign/movers/SetAtomTree.hh>
#include <protocols/ProteinInterfaceDesign/movers/IDMover_cc_headers.hh>
#include <core/conformation/Conformation.hh>


namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

using namespace core;
using namespace std;
using namespace core::scoring;
using namespace protocols::moves;

static core::util::Tracer TR( "protocols.ProteinInterfaceDesign.movers.SetAtomTree" );


void
SetAtomTree::parse_my_tag( TagPtr const tag, DataMap &, protocols::filters::Filters_map const &, Movers_map const &, core::pose::Pose const & pose )
{
	core::Size const  resnum( get_resnum( tag, pose ) );
	std::string const connect_to( tag->getOption<string>( "connect_to", "CA" ));
	core::Size const host_chain( tag->getOption<core::Size>( "host_chain", 2 ) );

	core::Size const begin( pose.conformation().chain_begin( host_chain == 1 ? 2 : 1 ) );
	core::Size const end( pose.conformation().chain_end( host_chain == 1 ? 2 : 1 ) );
	core::Real min_dist(10000);
	core::Size nearest_res( 0 );
	core::conformation::Residue const res_central( pose.residue( resnum ) );
	for( core::Size res=begin; res<=end; ++res ) {
		core::conformation::Residue const res2( pose.residue(res) );
		core::Real const distance( res_central.xyz( res_central.nbr_atom() ).distance( res2.xyz( res2.nbr_atom() ) ) );
		if( distance<=min_dist ) {
			min_dist = distance;
			nearest_res = res;
		}
	}

	core::Size const rb_jump( 1 );
	core::Size const jump_pos1( host_chain == 1 ? resnum : nearest_res );
	core::Size const jump_pos2( host_chain == 1 ? nearest_res : resnum );
	fold_tree_.clear();
	fold_tree_.add_edge( jump_pos1, jump_pos2, rb_jump );
	fold_tree_.add_edge( 1, jump_pos1, kinematics::Edge::PEPTIDE );
	fold_tree_.add_edge( jump_pos1, pose.conformation().chain_end( 1 ), kinematics::Edge::PEPTIDE );
	fold_tree_.add_edge( pose.conformation().chain_begin( 2 ), jump_pos2, kinematics::Edge::PEPTIDE );
	fold_tree_.add_edge( jump_pos2, pose.total_residue(), kinematics::Edge::PEPTIDE );
	fold_tree_.set_jump_atoms( rb_jump, pose.residue( jump_pos1 ).atom_type( pose.residue( jump_pos1 ).nbr_atom()).element(), connect_to );
	fold_tree_.reorder( 1 );

	TR<<"AtomTree saving the following atom tree:\n"<<fold_tree_<<std::endl;
}


} //movers
} //ProteinInterfaceDesign
} //protocols

