// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/SetAtomTree.hh
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_SetAtomTree_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_SetAtomTree_HH

#include <core/types.hh>
#include <core/pose/Pose.hh>
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/filters/Filter.fwd.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <core/kinematics/FoldTree.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

/// @brief a mover that sets a user-defined atom tree
class SetAtomTree : public protocols::moves::Mover
{
public :
	SetAtomTree() : protocols::moves::Mover( "AtomTree" ) {}
	SetAtomTree( core::kinematics::FoldTree const ft ) { fold_tree_ = ft; }
	void fold_tree( core::kinematics::FoldTree const ft ) { fold_tree_ = ft; }
	core::kinematics::FoldTree fold_tree() const { return( fold_tree_ ); }
	void apply( core::pose::Pose & pose ) { pose.fold_tree( fold_tree_ ); }
	protocols::moves::MoverOP clone() const {
		return (protocols::moves::MoverOP( new SetAtomTree( *this ) ) );
	}
	protocols::moves::MoverOP fresh_instance() const { return protocols::moves::MoverOP( new SetAtomTree ); }
	void parse_my_tag( utility::Tag::TagPtr const tag, protocols::moves::DataMap &, protocols::filters::Filters_map const &, protocols::moves::Movers_map const &, core::pose::Pose const & );
	virtual ~SetAtomTree() {};
private :
	core::kinematics::FoldTree fold_tree_;
};

} // movers
} // ProteinInterfaceDesign
} // protocols


#endif /*INCLUDED_protocols_ProteinInterfaceDesign_movers_SetAtomTree_HH*/
