// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file devel/ProteinInterfaceDesign/movers/SetupHotspotConstraintsMover.hh
/// @brief Derived classes from DockDesign for dock design
/// @author Sarel Fleishman (sarelf@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_SetupHotspotConstraintsMover_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_SetupHotspotConstraintsMover_HH

// Project Headers
#include <core/pose/Pose.fwd.hh>
#include <core/types.hh>
#include <protocols/moves/Mover.hh>
//#include <protocols/hotspot_hashing/HotspotHashingConstraints.hh>
#include <core/scoring/constraints/ConstraintSet.hh>
#include <protocols/hotspot_hashing/HotspotStubSet.hh>
#include <core/id/AtomID.fwd.hh>
//#include <core/pack/task/PackerTask.hh>
// C++ headers

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

class SetupHotspotConstraintsMover : public protocols::moves::Mover {

public:

	SetupHotspotConstraintsMover(
  //  core::pack::task::PackerTaskCOP packer_task,
		protocols::hotspot_hashing::HotspotStubSet const & hotspot_stub_set,
		core::Size const chain_to_design,
		core::Real const & CB_force_constant,
		core::Real const & worst_allowed_stub_bonus,
		bool const apply_self_energies,
		core::Real const & bump_cutoff,
		bool const apply_ambiguous_constraints,
		bool const colonyE
	) :
		protocols::moves::Mover( "SetupHotspotConstraintMover" ),
		chain_to_design_(chain_to_design),
		CB_force_constant_(CB_force_constant),
		worst_allowed_stub_bonus_(worst_allowed_stub_bonus),
		apply_self_energies_(apply_self_energies),
		bump_cutoff_(bump_cutoff),
		apply_ambiguous_constraints_(apply_ambiguous_constraints),
		colonyE_( colonyE)
	{
//		packer_task_ = packer_task->clone();
		hotspot_stub_set_ = new protocols::hotspot_hashing::HotspotStubSet( hotspot_stub_set );
	};

	SetupHotspotConstraintsMover( SetupHotspotConstraintsMover const & init ) :
		protocols::moves::Mover( init ),
//		packer_task_(init.packer_task_),
//		hotspot_stub_set_(init.hotspot_stub_set_),
		chain_to_design_( init.chain_to_design_),
		CB_force_constant_(init.CB_force_constant_),
		worst_allowed_stub_bonus_(init.worst_allowed_stub_bonus_),
		apply_self_energies_(init.apply_self_energies_),
		bump_cutoff_(init.bump_cutoff_),
		apply_ambiguous_constraints_(init.apply_ambiguous_constraints_),
		colonyE_( init.colonyE_ )
	{
		//packer_task_ = init.packer_task_->clone();
		hotspot_stub_set_ = new protocols::hotspot_hashing::HotspotStubSet( *init.hotspot_stub_set_ );
	};

	void apply( core::pose::Pose & pose ) {
		if ( colonyE_ ) {
			protocols::hotspot_hashing::HotspotStubSetOP colonyE_set = hotspot_stub_set_->colonyE();
			hotspot_stub_set_ = colonyE_set;
		}
		if ( std::abs(CB_force_constant_) > 1E-9 ) {
			hotspot_stub_set_->add_hotspot_constraints_to_pose( pose, chain_to_design_, hotspot_stub_set_,
				CB_force_constant_, worst_allowed_stub_bonus_, apply_self_energies_, bump_cutoff_, apply_ambiguous_constraints_ );
		} else {
			core::scoring::constraints::ConstraintSetOP empty_constraint_set = new core::scoring::constraints::ConstraintSet;
			pose.constraint_set( empty_constraint_set );
		}
	};

	protocols::moves::MoverOP clone() const {
		return protocols::moves::MoverOP( new SetupHotspotConstraintsMover( *this ) );
	};

private:
//	core::pack::task::PackerTaskOP packer_task_;
	protocols::hotspot_hashing::HotspotStubSetOP hotspot_stub_set_;
	core::Size const chain_to_design_;
	core::Real const CB_force_constant_;
	core::Real const worst_allowed_stub_bonus_;
	bool const apply_self_energies_;
	core::Real const bump_cutoff_;
	bool const apply_ambiguous_constraints_;
	bool const colonyE_;
};

} // movers
} // ProteinInterfaceDesign
} // devel

#endif /*INCLUDED_protocols_ProteinInterfaceDesign_movers_SetupHotspotConstraintsMover_HH*/

