// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/TryRotamers.hh
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_TryRotamers_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_TryRotamers_HH

#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>
#include <utility/Tag/Tag.fwd.hh>
#include <protocols/filters/Filter.fwd.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/DataMap.fwd.hh>
#include <core/scoring/ScoreFunction.fwd.hh>
#include <core/pack/rotamer_set/RotamerSet.hh>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

class TryRotamers : public protocols::moves::Mover
{
public:
	typedef core::scoring::ScoreFunctionCOP ScoreFunctionCOP;
	typedef core::scoring::ScoreFunction ScoreFunction;
	typedef core::pose::Pose Pose;
	typedef core::conformation::Residue Residue;
	typedef core::pack::rotamer_set::RotamerSetOP RotamerSetOP;

public:
	TryRotamers();
	TryRotamers( core::Size resnum,
		core::scoring::ScoreFunction const& scorefxn,
		protocols::filters::Filter const& final_filter,
		core::Size explosion = 0, // rotamer explosion
		core::Size jump_num = 1,
		bool clash_check = false
		);
	/// @param jump_num The jump number of the interface. 0 for no interface
	/// @note Pass everything through the final filter (True Filter)
	TryRotamers( core::Size resnum,
		core::scoring::ScoreFunction const& scorefxn,
		core::Size explosion = 0, // rotamer explosion
		core::Size jump_num = 1,
		bool clash_check = false
		);


	core::pack::rotamer_set::RotamerSetOP rotamer_set() { return rotset_ ; }
	void get_rotamer_set( core::pack::rotamer_set::RotamerSetOP const & rs ){
		rotset_ = rs;
		rotamer_it_ = begin();
	}

	// for direct access
	void set_resnum( core::Size const r ) { resnum_ = r; }
	void set_scorefxn( core::scoring::ScoreFunctionCOP scorefxn ){ scorefxn_ = scorefxn; }
	void apply( core::pose::Pose & pose );
	void parse_my_tag( utility::Tag::TagPtr const tag,
		protocols::moves::DataMap &,
		protocols::filters::Filters_map const &,
		protocols::moves::Movers_map const &,
		core::pose::Pose const & );
	core::pack::rotamer_set::Rotamers::const_iterator begin() const { return rotset_->begin(); }
	core::pack::rotamer_set::Rotamers::const_iterator end() const { return rotset_->end(); }

	protocols::moves::MoverOP clone() const { return( protocols::moves::MoverOP( new TryRotamers( *this ) ) ); }
	protocols::moves::MoverOP fresh_instance() const { return protocols::moves::MoverOP( new TryRotamers ); }
	virtual ~TryRotamers() {};
private:
	core::scoring::ScoreFunctionCOP scorefxn_;
	core::pack::rotamer_set::Rotamers::const_iterator rotamer_it_;
	core::pack::rotamer_set::RotamerSetOP rotset_;
	core::Size resnum_;
	core::Size jump_num_;
	bool clash_check_;
	core::Size explosion_; // rotamer explosion
	protocols::filters::FilterOP final_filter_; // filter. Defaults to TrueFilter
	utility::vector1< core::Size > shove_residues_; // a list of residues for which to use the shove_bb atom type, so that backbone atoms might clash.
};


} //movers
} // ProteinInterfaceDesign
} // protocols


#endif /*INCLUDED_protocols_ProteinInterfaceDesign_movers_TryRotamers_HH*/

