// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/movers/ddG.hh
/// @brief calculate interface ddg
/// @author Sarel Fleishman


#ifndef INCLUDED_protocols_ProteinInterfaceDesign_movers_ddG_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_movers_ddG_HH

// Package headers
#include <core/chemical/ResidueTypeSet.fwd.hh>
#include <core/kinematics/MoveMap.hh>
#include <core/options/option.hh>
#include <core/options/keys/OptionKeys.hh>
#include <core/pose/Pose.hh>
#include <core/scoring/ScoreType.hh>
#include <core/scoring/ScoreFunction.hh>
#include <core/scoring/ScoreFunction.fwd.hh>

#include <protocols/moves/MinMover.hh>
#include <protocols/moves/MonteCarlo.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/MoverContainer.hh>
#include <protocols/moves/RigidBodyMover.hh>
#include <protocols/moves/TrialMover.hh>
#include <core/types.hh>

#include <protocols/ProteinInterfaceDesign/movers/DesignRepackMover.hh>
#include <protocols/ProteinInterfaceDesign/movers/ddG.fwd.hh>
#include <protocols/filters/Filter.hh>
#include <string>

namespace protocols {
namespace ProteinInterfaceDesign {
namespace movers {

class ddG : public DesignRepackMover
{
public:
	typedef core::Real Real;
	typedef core::scoring::ScoreType ScoreType;
	typedef core::pose::Pose Pose;
public :
	ddG() : DesignRepackMover() {}
	ddG( core::scoring::ScoreFunctionCOP scorefxn_in, core::Size const jump=1 ) {
		scorefxn_ = new core::scoring::ScoreFunction( *scorefxn_in );
		rb_jump_ = jump;
	}
	void calculate( Pose const & pose );
	void report_ddG( std::ostream & out ) const;
	Real sum_ddG() const;
	core::Size rb_jump() const { return rb_jump_; }
	void rb_jump( core::Size j ) { rb_jump_ = j; }
	virtual ~ddG() {} ;
	protocols::moves::MoverOP fresh_instance() const { return (protocols::moves::MoverOP) new ddG; }
	protocols::moves::MoverOP clone() const { return (protocols::moves::MoverOP) new ddG( *this ); }
	void parse_my_tag(  utility::Tag::TagPtr const, protocols::moves::DataMap &, protocols::filters::Filters_map const &, protocols::moves::Movers_map const &, core::pose::Pose const& ) {}
private :
	std::map< ScoreType, Real > bound_energies_;
	std::map< ScoreType, Real > unbound_energies_;
	Real bound_total_energy_;
	Real unbound_total_energy_;
	core::scoring::ScoreFunctionOP scorefxn_;
	void fill_energy_vector( Pose const & pose, std::map<ScoreType, Real > & energy_map );
	core::Size rb_jump_;
};

} // movers
} // ProteinInterfaceDesign
} // protocols
#endif /*INCLUDED_protocols_ProteinInterfaceDesign_movers_ddG_HH*/

