// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file protocols/ProteinInterfaceDesign/read_patchdock.hh
/// @brief
/// @author Sarel Fleishman (sarelf@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_read_patchdock_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_read_patchdock_HH

#include <core/pose/Pose.fwd.hh>
#include <string>

// Project Headers
// C++ headers
namespace protocols {
namespace ProteinInterfaceDesign {

/// @brief if no native is read
void
read_poses( core::pose::Pose & input_pose, std::string & input_tag );

/// @brief reads input and native poses from file. If patchdock flags are used will read the patchdock transformation
/// and transform the input pose accordingly
void
read_poses( core::pose::Pose & input_pose, core::pose::Pose & native_pose, std::string & input_tag, std::string & native_tag );
}
}

#endif /*INCLUDED_READ_PATCHDOCK_H_*/

