// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file devel/ProteinInterfaceDesign/util.hh
/// @brief definition of classes for iterations of docking/design.
/// @author Sarel Fleishman (sarelf@u.washington.edu), Jacob Corn (jecorn@u.washington.edu)

#ifndef INCLUDED_protocols_ProteinInterfaceDesign_util_HH
#define INCLUDED_protocols_ProteinInterfaceDesign_util_HH

// Project Headers
#include <core/pose/Pose.fwd.hh>
#include <core/types.hh>
#include <core/scoring/constraints/Constraint.fwd.hh>
#include <utility/Tag/Tag.fwd.hh>

// C++ headers
#include <string>
#include <map>
// Unit headers

namespace protocols {
namespace ProteinInterfaceDesign {

//typedef std::pair< core::Size, bool > ResNumType;
//bool comp_ResNumType( ResNumType i, ResNumType j ){ return( i.first < j.first ); }

/// @brief removes ALL coordinate constraints from a pose. returns the constraints that were removed
core::scoring::constraints::ConstraintCOPs remove_coordinate_constraints_from_pose( core::pose::Pose & pose );

// @brief returns ConstraintCOPs matching only the backbone_stub_constraints currently in the pose
core::scoring::constraints::ConstraintCOPs get_bbcsts( core::pose::Pose const & pose );

/// @brief evaluate backbone_stub_constraints for each residue in a chain and return a vector with the top n_return residue numbers by cst score
/// note that this function is NOT guaranteed to return n_return residues! It will return the best n<=n_return
utility::vector1< core::Size >
best_bbcst_residues( core::pose::Pose const & pose, core::Size const chain, core::Size const n_return );

void find_lowest_constraint_energy_residue( core::pose::Pose const & pose, core::Size const chain, core::Size & resi, core::Real & lowest_energy );

/// @brief utility function for stub_based_atom_tree. tries to find an optimal cutpoint in a pose given two different boundaries.
core::Size best_cutpoint( core::pose::Pose & pose, core::Size const prev_u, core::Size const prev_d, core::Size const u, core::Size const d );

core::Size
get_resnum( utility::Tag::TagPtr const tag_ptr, core::pose::Pose const & pose, std::string const & prefix="" );

/// @brief Extracts a residue number from a string.
/// @detail Recognizes two forms of numbering:
///   - Rosetta residue numbers (numbered sequentially from 1 to the last residue
///     in the pose). These have the form [0-9]+
///   - PDB numbers. These have the form [0-9]+[A-Z], where the trailing letter
///     is the chain ID.
/// @return the rosetta residue number for the string, or 0 upon an error
core::Size parse_resnum(std::string const& resnum, core::pose::Pose const& pose);

/// @brief Extracts a list of residue numbers from a tag.
/// @details The tag should contain a comma-separated list of numbers, in either
///   pdb or rosetta format (@see parse_resnum for details)
utility::vector1<core::Size> get_resnum_list(utility::Tag::TagPtr const tag_ptr, std::string const& tag, core::pose::Pose const& pose);

/// @brief find nearest residue on target_chain to res
core::Size
find_nearest_residue( core::pose::Pose const & pose, core::Size const target_chain, core::Size const res, std::string const atom="CA" );

} // ProteinInterfaceDesign
} // protocols


#endif /*INCLUDED_DOCK_DESIGN_UTIL_H_*/

