// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @author Oliver Lange

#ifndef INCLUDED_protocols_abinitio_TemplateJumpSetup_HH
#define INCLUDED_protocols_abinitio_TemplateJumpSetup_HH

// Unit Headers
#include <protocols/abinitio/TemplateJumpSetup.fwd.hh>

// Package Headers
#include <protocols/abinitio/Templates.hh>
#include <protocols/jumping/JumpSetup.hh>
#include <protocols/jumping/SecondaryStructure.hh>

// Project Headers
#include <core/types.hh>

#include <core/fragment/FragSet.fwd.hh>
#include <core/fragment/FragData.fwd.hh>
#include <core/fragment/FrameList.fwd.hh>

#include <core/sequence/SequenceMapping.hh>

#include <protocols/jumping/PairingsList.hh>
#include <protocols/jumping/PairingLibrary.hh>
#include <protocols/jumping/JumpSample.hh>

// ObjexxFCL Headers

// Utility headers
#include <utility/pointer/ReferenceCount.hh>

//// C++ headers
#include <cstdlib>
#include <string>
#include <vector>

namespace protocols {
namespace abinitio {

class TemplateJumpSetup : public jumping::BaseJumpSetup {
public:
  TemplateJumpSetup(
				 TemplatesCOP templates,
				 jumping::SecondaryStructureCOP secstruct,
				 PairingStatisticsCOP,
				 jumping::PairingList const& helix_pairings
	);

	virtual
  jumping::JumpSample create_jump_sample() const;

	jumping::JumpSample clean_jumps( jumping::JumpSample const& ) const;

	//'	jumping::JumpSample
	//	create_jump_sample( std::string ModelID ) const;
  ///@brief returns an ordered FragSet that is compatible with the JumpSample
  /// default: generate jumps from ss-library according to JumpSample
  virtual
	core::fragment::FragSetOP generate_jump_frags( jumping::JumpSample const&, core::kinematics::MoveMap const& ) const;

	bool is_helix_jump( jumping::Pairing const& p ) const;

private:
  TemplatesCOP templates_;
  protocols::jumping::SecondaryStructureCOP secstruct_;

	PairingStatisticsCOP strand_stats_;
	jumping::PairingList helix_pairings_;
	//jumping::BasePairingLibraryOP geometry_library_; ///eventually plug in other sources for geometries .. needs a new interface -- not now
};

class FixTemplateJumpSetup : public TemplateJumpSetup {
public:
  FixTemplateJumpSetup( TemplatesCOP templates, jumping::SecondaryStructureCOP secstruct, PairingStatisticsCOP, jumping::PairingList const&,
		jumping::BaseJumpSetupOP jump_def );

  FixTemplateJumpSetup( TemplateJumpSetup const& templ, jumping::BaseJumpSetupOP jump_def );

	virtual
  jumping::JumpSample create_jump_sample() const;

private:
	jumping::BaseJumpSetupOP jump_def_;
};


} //abinitio
} //protocols

#endif
