// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author Aroop Sircar

#ifndef INCLUDED_protocols_antibody_AntibodyClass_HH
#define INCLUDED_protocols_antibody_AntibodyClass_HH

// Rosetta Headers
#include <core/kinematics/MoveMap.hh>
#include <core/pose/Pose.hh>
#include <core/types.hh>
#include <protocols/loops/LoopClass.hh>
// C++ Headers

// Utility Headers
#include <utility/vector1.hh>
///////////////////////////////////////////////////////////////////////////////
namespace protocols {
	namespace antibody {

		/// antibody definition
		class Antibody {

		public:
			/// default constructor
			Antibody();

			/// constructor with arguments
			Antibody( core::pose::Pose& pose_in );
			Antibody( core::pose::Pose& pose_in, std::string cdr_name );

			void set_defaults();

			void populate_all_cdrs();

			void all_cdr_fold_tree();

			/// align current Fv to native.Fv
			void align_to_native( antibody::Antibody & native );

			core::Size lfr_start_1;
			core::Size lfr_end_1;
			core::Size lfr_start_2;
			core::Size lfr_end_2;
			core::Size cdr_l1_start;
			core::Size cdr_l1_end;
			core::Size lfr_start_3;
			core::Size lfr_end_3;
			core::Size lfr_start_4;
			core::Size lfr_end_4;
			core::Size cdr_l2_start;
			core::Size cdr_l2_end;
			core::Size lfr_start_5;
			core::Size lfr_end_5;
			core::Size lfr_start_6;
			core::Size lfr_end_6;
			core::Size cdr_l3_start;
			core::Size cdr_l3_end;
			core::Size lfr_start_7;
			core::Size lfr_end_7;
			core::Size hfr_start_1;
			core::Size hfr_end_1;
			core::Size hfr_start_2;
			core::Size hfr_end_2;
			core::Size cdr_h1_start;
			core::Size cdr_h1_end;
			core::Size hfr_start_3;
			core::Size hfr_end_3;
			core::Size hfr_start_4;
			core::Size hfr_end_4;
			core::Size cdr_h2_start;
			core::Size cdr_h2_end;
			core::Size hfr_start_5;
			core::Size hfr_end_5;
			core::Size cdr_h3_start;
			core::Size cdr_h3_end;
			core::Size hfr_start_6;
			core::Size hfr_end_6;
			// Start coordinates of active loop
			core::Size current_start;
			// End coordinates of active loop
			core::Size current_end;

			// Pose containing antibody variable region, Fv
			core::pose::Pose Fv;

			bool kinked_;
			bool extended_;
			utility::vector1< char > Fv_sequence_;

			loops::Loops all_cdr_loops;

			core::kinematics::MoveMap ab_movemap;

		private:

			core::Size cdr_h3_cut_;

			void detect_CDR_H3_stem_type();
			void update_sequence();
		};


	} //namespace antibody
} //namespace protocols


#endif //INCLUDED_protocols_loops_AntibodyClass_HH
