// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file AntibodyModeler
/// @brief Build a homology model of an antibody
/// @detailed
///
///
/// @author Aroop Sircar


#ifndef INCLUDED_protocols_antibody_AntibodyModeler_HH
#define INCLUDED_protocols_antibody_AntibodyModeler_HH

#include <core/pose/Pose.fwd.hh>

#include <protocols/antibody/AntibodyModeler.fwd.hh>
#include <protocols/moves/Mover.hh>

namespace protocols {
	namespace antibody {

		class AntibodyModeler: public moves::Mover {
		public:
			AntibodyModeler();
			void set_default();
			virtual void apply( core::pose::Pose & pose_in );
			void set_snugdock_foldtree( core::pose::Pose & pose_in );

		private:

			// Modeling H3 options;
			bool model_h3_;
			bool snug_dock_;

		};

		int antibodyjob_main();
	}
}
#endif
