// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file src/protocols/comparative_modeling/CMPoseInputStream.hh
/// @brief
/// @author James Thompson

// libRosetta headers

#ifndef core_io_pose_stream_CMPoseInputStream_HH
#define core_io_pose_stream_CMPoseInputStream_HH

#include <core/types.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/sequence/SequenceAlignment.hh>
#include <core/chemical/ResidueTypeSet.fwd.hh>
#include <core/io/pose_stream/PoseInputStream.hh>
#include <core/io/pose_stream/PoseInputStream.fwd.hh>
#include <core/io/pose_stream/ExtendedPoseInputStream.hh>

#include <utility/vector1.hh>

namespace protocols {
namespace comparative_modeling {

class CMPoseInputStream : public core::io::pose_stream::PoseInputStream {

	typedef core::sequence::SequenceAlignment SequenceAlignment;

public:
	CMPoseInputStream() {}

	CMPoseInputStream(
		utility::vector1< SequenceAlignment > alns,
		utility::vector1< core::pose::Pose > template_poses
	) :
		alignments_( alns ),
		template_poses_( template_poses )
	{
		input_from_cmd_line_();
	}

	CMPoseInputStream(
		std::string const & seq,
		core::Size n_poses,
		utility::vector1< SequenceAlignment > alns,
		utility::vector1< core::pose::Pose > template_poses
	) :
		alignments_( alns ),
		template_poses_( template_poses )
	{
		extended_input_
			= new core::io::pose_stream::ExtendedPoseInputStream( seq, n_poses );
	}

	// accessors

	virtual ~CMPoseInputStream() {}

	virtual bool has_another_pose();

	virtual void fill_pose(
		core::pose::Pose & pose,
		core::chemical::ResidueTypeSet const & residue_set
	);

	void cst_filenames( utility::vector1< std::string > fns ) {
		cst_filenames_ = fns;
	}

private:
	void input_from_cmd_line_();
	SequenceAlignment get_random_alignment_(
		core::pose::Pose const & template_pose
	);
	core::pose::Pose get_random_template_();

	void add_random_constraints_(
		core::pose::Pose & query_pose,
		std::string const & match
	);

private:
	utility::vector1< std::string > cst_filenames_;
	utility::vector1< SequenceAlignment > alignments_;
	core::io::pose_stream::PoseInputStreamOP extended_input_;
	utility::vector1< core::pose::Pose > template_poses_;
}; // CMPoseInputStream

} // comparative_modeling
} // protocols

#endif
