// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @brief simple mover for stealing side chains from one pose and sticking them
/// on another pose.
/// @author James Thompson

#include <utility/vector1.hh>

#include <core/types.hh>
#include <core/pose/Pose.hh>
#include <core/conformation/Residue.hh>
#include <core/sequence/SequenceMapping.hh>

#include <protocols/moves/Mover.hh>
#include <protocols/comparative_modeling/StealSideChainsMover.hh>

namespace protocols {
namespace comparative_modeling {

StealSideChainsMover::StealSideChainsMover(
	core::pose::Pose const & source,
	core::sequence::SequenceMapping map
) :
	source_( source ),
	map_( map )
{}

/// maps from pose to source_
void StealSideChainsMover::apply( core::pose::Pose & pose ) {
	using core::Size;
	for ( Size ii = 1; ii <= map_.size1(); ++ii ) {
		if ( map_[ii] == 0 ) continue;
		// seqpos, new_residue, orient_backbone
		core::conformation::ResidueOP new_residue(
			source_.residue( map_[ii] ).clone()
		);
		pose.replace_residue ( ii, *new_residue, true );
		//pose.replace_residue ( ii, *new_residue, false );
	}
} // apply

} // comparative_modeling
} // protocols
