// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file docking_initialization_protocols
/// @brief initialization protocols for docking
/// @detailed
///		This contains the functions that create initial positions for docking
///		You can either randomize partner 1 or partner 2, spin partner 2, or
///		perform a simple perturbation.
/// @author Monica Berrondo
/// @author Modified by Sergey Lyskov


#ifndef INCLUDED_protocols_docking_DockingHighRes_HH
#define INCLUDED_protocols_docking_DockingHighRes_HH

// Package headers
#include <core/chemical/ResidueTypeSet.fwd.hh>
#include <core/kinematics/MoveMap.hh>
#include <core/pack/task/TaskFactory.fwd.hh>
#include <core/pose/Pose.fwd.hh>

#include <core/io/pdb/pose_io.hh>
#include <core/scoring/ScoreFunction.hh>
#include <core/scoring/ScoreFunctionFactory.hh>

#include <protocols/loops/LoopClass.fwd.hh>

#include <protocols/moves/MinMover.hh>
#include <protocols/moves/MonteCarlo.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/MoverContainer.hh>
#include <protocols/moves/PackRotamersMover.fwd.hh>
#include <protocols/moves/RotamerTrialsMover.fwd.hh>
#include <protocols/moves/RigidBodyMover.hh>
#include <protocols/moves/TrialMover.hh>
//#include <protocols/docking/DockingPackRotamers.fwd.hh>

#include <string>
// option key includes

namespace protocols {
namespace docking {

/// @brief this mover does the high resolution refinement stage of the RosettaDock algorithm
class DockingHighRes;
typedef utility::pointer::owning_ptr< DockingHighRes > DockingHighResOP;
typedef utility::pointer::owning_ptr< DockingHighRes const > DockingHighResCOP;

class DockingHighRes : public moves::Mover
{
	typedef core::Real Real;
public:

	// default constructor
	DockingHighRes();

	// constructor with arguments
	DockingHighRes(
		core::scoring::ScoreFunctionCOP scorefxn_in,
		int const rb_jump_in
	);

	// constructor with arguments
	DockingHighRes(
		core::scoring::ScoreFunctionCOP scorefxn_in,
		core::scoring::ScoreFunctionCOP scorefxn_pack_in,
		int const rb_jump_in
	);

	~DockingHighRes();

	//clone
	protocols::moves::MoverOP clone() const;

	void set_default( core::pose::Pose & pose );
	void set_move_map(core::kinematics::MoveMapOP movemap_in);
	void set_min_type( std::string min_type_in );
	void set_repack( bool repack_switch);
	void set_protocol( core::pose::Pose & pose );

	void define_loops( core::pose::Pose const & pose, loops::Loops & loop_set, Real & interface_dist );

	moves::MonteCarloOP get_mc();

	// protocol functions
	virtual void apply( core::pose::Pose & pose );

	void set_dock_min_protocol();
	void set_dock_mcm_protocol( core::pose::Pose & pose );
	void set_dock_ppk_protocol( core::pose::Pose & pose );

private:
	core::scoring::ScoreFunctionCOP scorefxn_;
	core::scoring::ScoreFunctionCOP scorefxn_pack_;
	core::kinematics::MoveMapOP movemap_;
	moves::SequenceMoverOP docking_highres_protocol_mover_;
	moves::MonteCarloOP mc_;

	// docking
	core::Size rb_jump_;
	core::Real trans_magnitude_, rot_magnitude_;
	bool chi_, bb_;
	bool repack_switch_; // master switch to turn repacking during docking on/off. Only makes sense if repack_period > 0
	bool rtmin_, scmin_;

	// packing
	core::pack::task::TaskFactoryOP tf_;
	core::Size repack_period_;
	core::Real temperature_;

	// minimization
	core::Real min_tolerance_;
	bool nb_list_;
	std::string min_type_;
};

} // docking
} // protocols

#endif
