// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file DockinLowRes
/// @brief low resolution mode for docking
/// @detailed
/// @author Monica Berrondo
/// @author Modified by Sergey Lyskov


#ifndef INCLUDED_protocols_docking_DockingLowRes_HH
#define INCLUDED_protocols_docking_DockingLowRes_HH

// Package headers
#include <core/chemical/ResidueTypeSet.fwd.hh>
#include <core/kinematics/MoveMap.hh>
#include <core/options/option.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/scoring/ScoreFunction.fwd.hh>

#include <protocols/moves/MoverContainer.fwd.hh>
#include <protocols/moves/MonteCarlo.fwd.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/RigidBodyMover.fwd.hh>

#include <string>


// option key includes

#include <core/options/keys/docking.OptionKeys.gen.hh>

namespace protocols {
namespace docking {

/// @brief this mover does the low-resolution centroid mode phase of the RosettaDock algorithm
class DockingLowRes;
typedef utility::pointer::owning_ptr< DockingLowRes > DockingLowResOP;
typedef utility::pointer::owning_ptr< DockingLowRes const > DockingLowResCOP;


class DockingLowRes : public moves::Mover
{
	typedef core::Real Real;
public:

	DockingLowRes();

	// destructor
	~DockingLowRes();

	// constructor with arguments
	DockingLowRes(
		core::scoring::ScoreFunctionCOP scorefxn_in,
		int const rb_jump_in=1
	);

	protocols::moves::MoverOP clone() const;


	void set_default( core::pose::Pose & pose );

	void set_default_mc( core::pose::Pose & pose );
	void set_default_protocol( core::pose::Pose & pose);
	void set_flexible_docking_protocol( core::pose::Pose & pose);
	void set_default_move_map();

	moves::MonteCarloOP get_mc();

	// protocol functions
	virtual void apply( core::pose::Pose & pose );
	void rigid_body_trial( core::pose::Pose & pose );

private:
	// protocol stuff
	core::scoring::ScoreFunctionCOP scorefxn_;
	core::kinematics::MoveMapOP movemap_;
	moves::MonteCarloOP mc_;
	moves::SequenceMoverOP docking_lowres_protocol_;
	moves::RigidBodyPerturbNoCenterMoverOP rb_mover_;

	// docking
	int rb_jump_, inner_cycles_, outer_cycles_;
	Real trans_magnitude_, rot_magnitude_, accept_rate_;
	bool chi_, bb_, nb_list_;

	Real temperature_;

};

} // docking
} // protocols

#endif
