// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author Sid Chaudhury
#ifndef INCLUDED_protocols_docking_SidechainMinMover_HH
#define INCLUDED_protocols_docking_SidechainMinMover_HH

// Unit headers
#include <protocols/docking/SidechainMinMover.fwd.hh>

// Project headers
#include <core/conformation/Interface.fwd.hh>
#include <core/conformation/Interface.hh>
#include <core/scoring/ScoreFunction.hh>
#include <core/scoring/ScoreFunctionFactory.hh>
#include <core/types.hh>

#include <core/pack/task/PackerTask.hh>
#include <core/pack/task/TaskFactory.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/kinematics/MoveMap.fwd.hh>
#include <core/kinematics/MoveMap.hh>
#include <protocols/moves/Mover.fwd.hh>
#include <protocols/moves/Mover.hh>
#include <protocols/moves/MinMover.fwd.hh>
#include <protocols/moves/MinMover.hh>
#include <protocols/moves/MonteCarlo.fwd.hh>
#include <protocols/moves/MonteCarlo.hh>
#include <protocols/moves/PackRotamersMover.fwd.hh>
#include <protocols/moves/PackRotamersMover.hh>
#include <protocols/moves/RotamerTrialsMover.hh>
#include <protocols/moves/RotamerTrialsMover.fwd.hh>

namespace protocols {
namespace docking {

class SidechainMinMover : public moves::Mover {
public:

	// default constructor
	SidechainMinMover();

	//constructors with arguments
	SidechainMinMover( core::scoring::ScoreFunctionCOP scorefxn_in );
	SidechainMinMover( core::scoring::ScoreFunctionCOP scorefxn_in,core::kinematics::MoveMapOP movemap_in );
	SidechainMinMover( core::scoring::ScoreFunctionCOP scorefxn_in, core::pack::task::PackerTaskOP);
	SidechainMinMover( core::scoring::ScoreFunctionCOP scorefxn_in, core::pack::task::TaskFactoryOP );

	// destructor
	~SidechainMinMover();

	void set_default_options();

	void set_minmover( moves::MinMoverOP minmover_in );

	void update_movemap( core::pose::Pose & pose );

	virtual void apply( core::pose::Pose & pose );

protected:

	core::scoring::ScoreFunctionCOP scorefxn_;
	moves::MinMoverOP minmover_;
	core::kinematics::MoveMapOP movemap_;
	core::pack::task::PackerTaskOP task_;
	core::pack::task::TaskFactoryOP tf_;
	bool update_movemap_;

	};


class InterfaceSidechainMinMover : public SidechainMinMover {
public:

	//default constructor
	InterfaceSidechainMinMover();

	// constructor with arguments
	InterfaceSidechainMinMover(
		core::Size rb_jump_in,
		core::scoring::ScoreFunctionCOP scorefxn_in,
		core::Real interface_dist_in=8.0
	);

	// destructor
	~InterfaceSidechainMinMover();

	void set_default_options();

	void set_norepack1( bool no_repack1_in){ no_repack1_ = no_repack1_in; }
	void set_norepack2( bool no_repack2_in){ no_repack2_ = no_repack2_in; }

	void set_interface_dist( core::Real interface_dist_in);

	virtual void apply( core::pose::Pose & pose );

private:

	bool no_repack1_;
	bool no_repack2_;
	core::Size rb_jump_;
	core::Real interface_dist_;

	core::conformation::InterfaceOP interface_;

	};

} //docking
} // protocols


#endif
