// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file   protocols/enzdes/EnzdesBaseProtocol.hh
///
/// @brief
/// @author Florian Richter




#ifndef INCLUDED_protocols_enzdes_EnzdesBaseProtocol_HH
#define INCLUDED_protocols_enzdes_EnzdesBaseProtocol_HH


#include <protocols/enzdes/EnzdesBaseProtocol.fwd.hh>
#include <protocols/enzdes/EnzConstraintIO.fwd.hh>
#include <protocols/enzdes/DesignVsNativeComparison.hh>

#include <protocols/ligand_docking/LigandBaseProtocol.hh>
#include <core/scoring/EnergyMap.fwd.hh>
#include <core/sequence/SequenceMapping.fwd.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/pack/task/PackerTask.fwd.hh>
#include <core/chemical/ResidueTypeSet.fwd.hh>
#include <core/io/silent/SilentEnergy.hh>


namespace protocols{
namespace enzdes{


class EnzdesBaseProtocol : public protocols::ligand_docking::LigandBaseProtocol
{

public:

	EnzdesBaseProtocol();

	//virtual void apply( core::pose::Pose & pose) const = 0;

	EnzConstraintIOOP cst_io(){ return cst_io_; }

 //catalytic res INCLUDING all ligands in pose numbering in a particular order
	utility::vector1<Size> catalytic_res( core::pose::Pose const & pose) const;

	utility::vector1< std::string > relevant_scoreterms(){
		return relevant_scoreterms_; }

	std::map< Size, utility::vector1< std::pair< std::string, std::string > > > res_calculators(){ return residue_calculators_;};

	std::set< Size > const & design_targets( core::pose::Pose const & pose ) const;

	bool
	is_catalytic_position( core::Size const seqpos ) const;

	static core::Real
	sum_constraint_scoreterms(
		core::pose::Pose const & pose,
		int which_res
	);

	static void register_options();

	core::chemical::ResidueTypeSetCAP
	restype_set() const {
		return restype_set_; }

	void
	generate_explicit_ligand_rotamer_poses(
		core::pose::Pose const & orig_pose,
		utility::vector1< core::pose::PoseOP > & ligrot_poses,
		core::scoring::ScoreFunctionCOP scofx
	);

	utility::vector1< core::io::silent::SilentEnergy > const & silent_Es(){
		return silent_Es_; }

	utility::vector1< std::pair< std::string, std::string > > const &
	calculators_for_residue( core::Size res ) const;

	utility::vector1< std::pair< std::string, std::string > > const &
	native_compare_calculators() const {
		return native_compare_calculators_; }

	core::scoring::ScoreFunctionCOP
	reduced_scorefxn() const {
		return reduced_sfxn_; }

	core::Real
	design_targets_score(
		core::pose::Pose const & pose
	) const;


	void
	examine_pose(
		core::pose::Pose const & pose,
		utility::vector1< core::io::silent::SilentEnergy > & silent_Es
	);

	virtual
	void
	remap_resid(
		core::pose::Pose const & pose,
		core::sequence::SequenceMapping const & smap
	);

	void
	remove_enzdes_constraints(
		core::pose::Pose & pose,
		bool keep_covalent
	);

	void
	add_pregenerated_enzdes_constraints(
		core::pose::Pose & pose
	);

	void
	cst_minimize(
		core::pose::Pose & pose,
		core::pack::task::PackerTaskCOP task,
		bool cst_opt = false
	);


protected:


	core::pack::task::PackerTaskOP
	create_enzdes_pack_task(
		core::pose::Pose const& pose,
		bool design = true
	); //the task

	void
	enzdes_pack(
		core::pose::Pose & pose,
		core::pack::task::PackerTaskCOP,
		core::scoring::ScoreFunctionCOP scorefxn,
		core::Size cycles,
		bool pack_unconstrained,
		bool minimize_unconstrained,
		bool favor_native
	);

	void
	find_design_interface(
		core::pose::Pose const & pose,
		Size jump_id,
		core::Real cut1,
		core::Real cut2,
		core::Real cut3,
		core::Real cut4,
		utility::vector1< bool > & repack_res,
		utility::vector1< bool > & design_res
	);

	void
	setup_enzdes_constraints(
		core::pose::Pose & pose,
		bool allow_missing_remark_blocks
	);


	void
	setup_pose_metric_calculators(
		core::pose::Pose const & pose
	);

	void enable_constraint_scoreterms();

	/// @brief function to disable constraint scoring terms:
	/// @NOTE: this will leave eventual covalent connections set up by EnzConstraintIO untouched.
	void disable_constraint_scoreterms();


	bool
	exchange_ligands_in_pose(
		core::pose::Pose & pose,
		bool check_bb_clashes,
		core::scoring::ScoreFunctionCOP scofx
	);


	DesignVsNativeComparisonOP native_comp_;
	utility::vector1< core::io::silent::SilentEnergy > silent_Es_;

	core::scoring::ScoreFunctionOP reduced_sfxn_;

	mutable std::set< core::Size > design_targets_;

private:

	void
	read_ligand_superposition_file( std::string filename );

	//data

	EnzConstraintIOOP cst_io_;
	std::map< Size, utility::vector1< std::pair< std::string, std::string > > > residue_calculators_;
	utility::vector1< std::pair< std::string, std::string > > native_compare_calculators_;


	core::chemical::ResidueTypeSetCAP restype_set_;
	core::scoring::EnergyMap constraint_weights_;
	utility::vector1< std::string > relevant_scoreterms_;

	core::Real bb_min_allowed_dev_;

	//stuff for optional ligand superposition
	bool lig_superposition_file_read_;
	std::pair< std::string, std::string > res_to_superimpose_;
	utility::vector1< std::pair< std::string, std::string > > atoms_to_superimpose_on_;

	bool exclude_protein_protein_hack_elec_;

}; //class EnzdesBaseProtocol


} //namespace enzdes
} //namespace protocols




#endif // INCLUDED_protocols_enzdes_EnzdesBaseProtocol_HH
