// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file src/protocols/enzdes/EnzdesMovers.hh
/// @brief a collection of movers that are used at different stages in enzyme design
/// @author Sinisa Bjelic, Florian Richter, floric@u.washington.edu


#ifndef INCLUDED_protocols_enzdes_EnzdesMovers_HH
#define INCLUDED_protocols_enzdes_EnzdesMovers_HH

#include <protocols/enzdes/EnzdesMovers.fwd.hh>
#include <protocols/enzdes/EnzdesBaseProtocol.fwd.hh>

// Unit headers
//#include <protocols/enzdes/EnzConstraintIO.fwd.hh>
#include <protocols/moves/RigidBodyMover.hh>

// Package headers
#include <core/scoring/constraints/Constraints.hh>
#include <core/scoring/constraints/Func.fwd.hh>
#include <core/scoring/constraints/MultiConstraint.fwd.hh>
#include <core/scoring/ScoreFunction.fwd.hh>

// Project headers
#include <core/conformation/Residue.fwd.hh>
#include <core/chemical/ResidueTypeSet.fwd.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/pack/task/PackerTask.fwd.hh>
#include <core/scoring/constraints/ConstraintSet.hh>

// Utility Headers
#include <utility/pointer/ReferenceCount.hh>
#include <numeric/xyzVector.io.hh>

//Utility Headers

// C++ Headers

namespace protocols {
namespace enzdes {


class PredesignPerturbMover : public protocols::moves::RigidBodyPerturbMover
{

public:
  //Deafault constructor
  PredesignPerturbMover();
  //Constructor to be used with the apply function
	PredesignPerturbMover(  core::pack::task::PackerTaskCOP task_in,  EnzdesBaseProtocolCOP enzdes_prot_in);

	void
  set_docking_pose(
	core::pose::Pose &pose,
	core::pack::task::PackerTaskCOP task,
  EnzdesBaseProtocolCOP enzdes_prot
	);

	void
  reinstate_pose(
	core::pose::Pose &pose,
	core::pose::Pose const &old_Pose
	);

  void
  add_constrained_lig_atoms_from_multiconstraint(
  core::scoring::constraints::MultiConstraintCOP real_multi_constraint
  );


  void
  add_constrained_lig_atom(
  core::Size atom_no
  );

  void
  find_constraints_to_ligand(
  core::pose::Pose const &pose
  );

  void
  apply(
  core::pose::Pose &pose
  );

  void
  set_ligand(core::Size res_no) {
  ligand_seqpos_=res_no;
  }

	utility::vector1< core::Size > get_constrained_lig_atoms() const {
  return constrained_lig_atoms_;
  }

 core::Vector
 find_geometric_center_for_constrained_lig_atoms(
 core::pose::Pose const &pose
 );

private:
	//core::Size dock_trials_;
  core::pack::task::PackerTaskCOP task_;
  EnzdesBaseProtocolCOP enzdes_prot_;

	utility::vector1< core::Size >positions_to_replace_;
  utility::vector1< core::Size >constrained_lig_atoms_;
  //Ligand's sequence position
  core::Size ligand_seqpos_;
};

} //enzdes
} //protocols


#endif
