// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file src/protocols/enzdes/enzdes_util.hh
/// @brief a bunch of utility functions used in enzdes
/// @author Florian Richter, floric@u.washington.edu


#ifndef INCLUDED_protocols_enzdes_enzdes_util_HH
#define INCLUDED_protocols_enzdes_enzdes_util_HH


// Unit headers
//#include <protocols/enzdes/EnzConstraintIO.fwd.hh>

// Package headers
#include <core/scoring/constraints/Constraints.hh>
#include <core/scoring/constraints/Func.fwd.hh>

#include <core/scoring/ScoreFunction.fwd.hh>

// Project headers
#include <core/conformation/Residue.fwd.hh>
#include <core/chemical/ResidueTypeSet.fwd.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/pack/task/PackerTask.fwd.hh>
#include <core/sequence/SequenceMapping.fwd.hh>


// Utility Headers
#include <utility/pointer/ReferenceCount.hh>
#include <set>


//Utility Headers

// C++ Headers

namespace protocols {
namespace enzdes {
namespace enzutil {

void
replace_residue_keeping_all_atom_positions(
	core::pose::Pose & pose,
	core::conformation::Residue new_res,
	core::Size res_pos
);


void
make_continuous_true_regions_in_bool_vector(
	utility::vector1< bool > & the_vector,
 	core::Size const min_number_continuous_trues
);

core::pack::task::PackerTaskOP
recreate_task(
	core::pose::Pose const & pose,
	core::pack::task::PackerTask const & orig_task
);

std::string
assemble_remark_line(
	std::string chainA,
	std::string resA,
	int seqposA,
	std::string chainB,
	std::string resB,
	int seqposB,
	core::Size cst_block,
	core::Size ex_geom_id = 1
);


bool
split_up_remark_line(
	std::string line,
	std::string & chainA,
	std::string & resA,
	int & seqposA,
	std::string & chainB,
	std::string & resB,
	int & seqposB,
	core::Size & cst_block,
	core::Size & ex_geom_id
);


/// @brief make one sequence mapping out of all input ones
core::sequence::SequenceMappingOP
combine_sequence_mappings(
	utility::vector1< core::sequence::SequenceMapping > const & smaps
);

/// @brief combine the input sequence mappings into one
void
combine_sequence_mappings(
	core::sequence::SequenceMapping & smap,
	core::sequence::SequenceMapping const & smap_to_add
);

std::string
get_pdb_code_from_pose_tag( core::pose::Pose const & pose );

///@TODO delete and use cctype functions
bool
is_digit( char * cha );

///@TODO delete and use cctype functions
bool
is_uppercase_letter( char * cha);

///@TODO delete and use cctype functions
bool
is_lowercase_letter( char * cha );


}
} //enzdes
} //protocols


#endif
