// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file relax_initialization_protocols
/// @brief
/// @detailed
///	  For diagnosis. Run with this TrialMover and get a log-file containing output from the provided PoseEvalutor
///    and if it was accepted or not.
///
///
/// @author Oliver Lange



#ifndef INCLUDED_protocols_evaluation_EvaluatedTrialMover_HH
#define INCLUDED_protocols_evaluation_EvaluatedTrialMover_HH


// Unit Headers


// Package Headers
#include <protocols/evaluation/PoseEvaluator.hh>
#include <protocols/evaluation/ScoreEvaluator.hh>
#include <protocols/moves/TrialMover.hh>

// Project Headers
#include <core/io/silent/silent.fwd.hh>
#include <core/pose/Pose.fwd.hh>

// ObjexxFCL Headers

// Utility headers
#include <utility/pointer/ReferenceCount.hh>
#include <utility/vector1.hh>

//// C++ headers
#include <list>

namespace protocols {
namespace evaluation {


class EvaluatedTrialMover;
typedef  utility::pointer::owning_ptr< EvaluatedTrialMover >  EvaluatedTrialMoverOP;


class EvaluatedTrialMover : public moves::TrialMover {
public:
  /// c'stor
  EvaluatedTrialMover(  moves::MoverOP mover_in, moves::MonteCarloOP mc_in, evaluation::PoseEvaluatorOP evaluator_in, std::string tag ) :
	  TrialMover( mover_in, mc_in),
	  tag_( tag )
  {
    evaluator_ = new evaluation::MetaPoseEvaluator;
    evaluator_->add_evaluation( new evaluation::ScoreEvaluator( "full",mc_in->score_function().clone() ) );
    evaluator_->add_evaluation( evaluator_in );
  }

  /// apply does a single trial (which is a mover apply and a boltzmann)
  virtual void apply( core::pose::Pose & pose );

  /// write all collected output to file (appends if file exist )
  void dump_file( std::string fn );
private:
  evaluation::MetaPoseEvaluatorOP evaluator_;
  typedef utility::vector1< core::io::silent::SilentStructOP > SilentInfoList;
  SilentInfoList evals_;
  std::string tag_;  //the decoy_output tag
};


}
}

#endif
