// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file PoseEvaluator
/// @brief PoseEvaluator
/// @detailed
///
///
/// @author Oliver Lange



// Unit Headers
#include <protocols/evaluation/ExternalEvaluator.hh>
#include <core/options/option.hh>

// Package Headers

// Project Headers
#include <core/io/silent/SilentStruct.hh>
#include <core/pose/Pose.hh>

// ObjexxFCL Headers
#include <ObjexxFCL/string.functions.hh>

// Utility headers
#include <core/util/Tracer.hh>
#include <utility/io/izstream.hh>
#include <utility/io/ozstream.hh>
#include <utility/io/util.hh>
#include <utility/file/file_sys_util.hh>
#include <numeric/random/random.hh>

// C++ headers
#include <cstdlib>
#include <string>
#include <vector>
#include <sys/stat.h>

// option key includes

#include <core/options/keys/out.OptionKeys.gen.hh>


// C++ headers

static core::util::Tracer tr("protocols.evaluation.ExternalEvaluator");

static numeric::random::RandomGenerator RG(5512489);  // <- Magic number, do not change it!

namespace protocols {
namespace evaluation {

using namespace core;
using namespace std;


ExternalEvaluator::ExternalEvaluator( std::string tag, std::string command )
  : SingleValuePoseEvaluator<core::Real>( tag ),
    command_( command )
{
// this probably shouldn't go on BOINC
#ifndef WIN32
#ifndef BOINC

	using namespace core::options;
	if ( !option[ OptionKeys::out::path::scratch ].user() ) {
		tr.Warning << "******************************************************************************************************\n"
							 << "                       no scratch dir defined  \n" << "   use -out:path:scratch \n"
							 << "******************************************************************************************************\n" << endl;
		scratch_dir_ = "/scratch/USERS/olange/";
	} else {
		scratch_dir_ = option[ OptionKeys::out::path::scratch ]();
	}
	if ( !utility::file::file_exists( scratch_dir_.c_str() ) ) mkdir( scratch_dir_.c_str(), S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH );

	string const tmp_file_name ("_ExternalEvaluator_"+name( 1 ));

  string dir = "./";
  if ( option[ OptionKeys::out::file::silent ].user() ) {
    dir = option[ OptionKeys::out::file::silent ]();
  }

	//also use random number!

	string sub_work_dir;
	{// if processes write silent files to subdirectory ... get this path
		string dircmd( "echo `dirname "+dir+"` | sed s@/@_@g");
		FILE* get_dir = popen(dircmd.c_str(),"r");
		char buf[500];
		fgets(buf,500,get_dir);
		buf[strlen(buf)-1]='\0';
		sub_work_dir = string( buf )+"_"+tmp_file_name; //get rid of newline
		pclose( get_dir );
	}
	sub_work_dir = sub_work_dir+"_"+ ObjexxFCL::string_of( RG.random_range(0, 999999) );


	{ // get our working path
		string dircmd( "pwd | sed s@/@_@g");
		FILE* get_dir = popen(dircmd.c_str(),"r");
		char buf[500];
		fgets(buf,500,get_dir);
		buf[strlen(buf)-1]='\0';
		string tmp_id = string( buf );
		work_dir_ = tmp_id.substr( max(0, (int)tmp_id.size()-40) );
		pclose( get_dir );
	}


	work_dir_ = scratch_dir_+work_dir_;
	tr.Info << "create scratch space... : " << work_dir_ << std::endl;
	if ( !utility::file::file_exists( work_dir_.c_str() ) ) mkdir(work_dir_.c_str(), S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH );
	work_dir_ = work_dir_+"/"+sub_work_dir;
	tr.Info << "create scratch space... : " << work_dir_ << std::endl;
	if ( !utility::file::file_exists( work_dir_.c_str() ) ) mkdir(work_dir_.c_str(), S_IRWXU | S_IRWXG | S_IROTH | S_IXOTH );
#endif
#endif
}


core::Real ExternalEvaluator::apply( core::pose::Pose& pose ) const {
	using namespace core::options;

  if ( !applicable( pose ) ) return 99999;

  string const command_buf( "DIR="+work_dir_+"; cd $DIR; "+command_+"; cd -");

  string const pose_file_name( work_dir_+string("/__POSE.pdb") );
  string const result_file_name( work_dir_+string("/__RESULT") );
  pose.dump_pdb( pose_file_name );

	tr.Info << "execute command: "<< command_buf << endl;
	system(command_buf.c_str());
	//execl("/bin/bash","bash","-c",command_buf.c_str(), (char *)0);

  utility::io::izstream result_file( result_file_name );
  core::Real result;
  result_file >> result;

  tr.Debug << "obtained result: " << result << endl;
  return result;
}

ExternalEvaluator::~ExternalEvaluator() {
	std::string command = "rm -Rf "+work_dir_;
	system(command.c_str());
	//clean up
}

// core::Real ExternalEvaluator::apply( core::pose::Pose& pose_in  ) const {
// 	pose::Pose pose( pose_in );

// 	runtime_assert( constraints_ );
// 	pose.constraint_set( constraints_ );

// 	ScoreFunction scfxn;
// 	scfxn.set_weight( atom_pair_constraint, 1.0 );
// 	return scfxn( pose );

// }


}
}
