// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file PoseEvaluator.fwd.hh
/// @brief
/// @detailed
///
///
/// @author Oliver Lange
///


#ifndef INCLUDED_protocols_evaluation_PoseEvaluator_FWD_HH
#define INCLUDED_protocols_evaluation_PoseEvaluator_FWD_HH

// Utility headers
#include <utility/pointer/owning_ptr.hh>

namespace protocols {
namespace evaluation {

class PoseEvaluator;
class MetaPoseEvaluator;

template <class T>
class SingleValuePoseEvaluator;

typedef utility::pointer::owning_ptr< PoseEvaluator > PoseEvaluatorOP;
typedef utility::pointer::owning_ptr< PoseEvaluator const > PoseEvaluatorCOP;

typedef utility::pointer::owning_ptr< MetaPoseEvaluator > MetaPoseEvaluatorOP;

class ConstraintEvaluator;
typedef utility::pointer::owning_ptr< ConstraintEvaluator > ConstraintEvaluatorOP;
typedef utility::pointer::owning_ptr< ConstraintEvaluator const > ConstraintEvaluatorCOP;



}
}


#endif
