// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file relax_initialization_protocols
/// @brief initialization protocols for relax
/// @detailed
///	  Contains currently: Classic Abinitio
///
///
/// @author Oliver Lange



#ifndef INCLUDED_protocols_evaluation_RmsdEvaluator_HH
#define INCLUDED_protocols_evaluation_RmsdEvaluator_HH


// Unit Headers
#include <protocols/evaluation/PoseEvaluator.hh>

// Package Headers
#include <protocols/evaluation/util.hh>

// Project Headers
#include <core/io/silent/silent.fwd.hh>
#include <core/pose/Pose.fwd.hh>

// ObjexxFCL Headers

// Utility headers
#include <utility/pointer/ReferenceCount.hh>
#include <utility/vector1.hh>

//// C++ headers
#include <list>

namespace protocols {
namespace evaluation {

extern void invert_exclude_residues( core::Size nres, utility::vector1<int> const& exclude_list, ResidueSelection& );

inline ResidueSelection invert_exclude_residues( core::Size nres, utility::vector1<int> const& exclude_list ) {
	ResidueSelection tmp;
	invert_exclude_residues( nres, exclude_list, tmp );
	return tmp;
}

extern core::Real native_CA_rmsd( const core::pose::Pose &native_pose ,  const core::pose::Pose &pose );

class RmsdEvaluator : public SingleValuePoseEvaluator< core::Real > {
public:
	RmsdEvaluator( core::pose::PoseCOP, core::Size start, core::Size end, std::string tag = "", bool bGDT = true );
	RmsdEvaluator( core::pose::PoseCOP, std::string tag = "", bool bGDT = true );

	virtual void
	apply ( core::pose::Pose& pose, std::string tag, core::io::silent::SilentStruct &pss) const;

	///@brief evaluate pose
	virtual core::Real apply( core::pose::Pose& ) const;

	void report_gdt_components( bool const setting ){ report_gdt_components_ = setting; }

private:
	core::pose::PoseCOP rmsd_pose_;
	core::Size start_;
	core::Size end_;
	bool bGDT_;
	std::string tag_;
	bool report_gdt_components_;
};

class SelectRmsdEvaluator : public SingleValuePoseEvaluator< core::Real > {
public:
	SelectRmsdEvaluator( core::pose::PoseCOP, ResidueSelection const& selection, std::string tag = "" );
	SelectRmsdEvaluator( core::pose::PoseCOP, utility::vector1< core::Size> const& selection, std::string tag = "" );

	//work it out by yourself from missing density == whacky random coords
	SelectRmsdEvaluator( core::pose::PoseCOP, std::string tag = "" );

	//work it out by yourself from missing density == whacky random coords
	SelectRmsdEvaluator( core::pose::Pose const&, std::string tag = "" );

	///@brief evaluate pose
	virtual core::Real apply( core::pose::Pose& ) const;

private:
	core::pose::PoseCOP rmsd_pose_;
	ResidueSelection selection_;
	std::string tag_;
};

class SelectGdtEvaluator : public SingleValuePoseEvaluator< core::Real > {
public:
	SelectGdtEvaluator( core::pose::PoseCOP, ResidueSelection const& selection, std::string tag = "" );
	SelectGdtEvaluator( core::pose::PoseCOP, utility::vector1< core::Size> const& selection, std::string tag = "" );

	//work it out by yourself from missing density == whacky random coords
	SelectGdtEvaluator( core::pose::PoseCOP, std::string tag = "" );

	//work it out by yourself from missing density == whacky random coords
	SelectGdtEvaluator( core::pose::Pose const&, std::string tag = "" );

	///@brief evaluate pose
	virtual core::Real apply( core::pose::Pose& ) const;

private:
	core::pose::PoseCOP rmsd_pose_;
	ResidueSelection selection_;
	std::string tag_;
};

class SelectMaxsubEvaluator : public SingleValuePoseEvaluator< core::Real > {
public:
	SelectMaxsubEvaluator( core::pose::PoseCOP, ResidueSelection const& selection, std::string tag = "" );
	SelectMaxsubEvaluator( core::pose::PoseCOP, utility::vector1< core::Size> const& selection, std::string tag = "" );

	//work it out by yourself from missing density == whacky random coords
	SelectMaxsubEvaluator( core::pose::PoseCOP, std::string tag = "" );

	//work it out by yourself from missing density == whacky random coords
	SelectMaxsubEvaluator( core::pose::Pose const&, std::string tag = "" );

	///@brief evaluate pose
	virtual core::Real apply( core::pose::Pose& ) const;

private:
	core::pose::PoseCOP rmsd_pose_;
	ResidueSelection selection_;
	std::string tag_;
};

class SymmetricRmsdEvaluator : public SingleValuePoseEvaluator< core::Real > {
public:
	SymmetricRmsdEvaluator( core::pose::PoseCOP, std::string tag );

	virtual core::Real apply ( core::pose::Pose& ) const;

private:
  core::pose::PoseCOP rmsd_pose_;

};

}
}

#endif
