// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file relax_initialization_protocols
/// @brief initialization protocols for relax
/// @detailed
///	  Contains currently: Classic Abinitio
///
///
/// @author Oliver Lange



#ifndef INCLUDED_protocols_evaluation_ScoreEvaluator_HH
#define INCLUDED_protocols_evaluation_ScoreEvaluator_HH


// Unit Headers
// #include <protocols/evaluation/ScoreEvaluator.fwd.hh>

// Package Headers
#include <protocols/evaluation/PoseEvaluator.hh>

// Project Headers
#include <core/io/silent/silent.fwd.hh>
#include <core/pose/Pose.fwd.hh>
#include <core/scoring/ScoreFunction.hh>
#include <protocols/evaluation/util.hh>

// ObjexxFCL Headers

// Utility headers


//// C++ headers

namespace protocols {
namespace evaluation {

///@brief that rewrites the whole pss struct all previous entries will be lost... probably not what one wants...
class ScoreEvaluator : public SingleValuePoseEvaluator< core::Real > {
public:
	ScoreEvaluator( std::string tag, core::scoring::ScoreFunctionOP scorefxn );

	virtual core::Real
	apply( core::pose::Pose& pose ) const;

private:
  core::scoring::ScoreFunctionOP scorefxn_;
};

class TruncatedScoreEvaluator : public SingleValuePoseEvaluator< core::Real > {
public:
	TruncatedScoreEvaluator( std::string tag, ResidueSelectionVector const&, core::scoring::ScoreFunctionOP scorefxn=NULL );
	///@brief evaluate pose
	virtual core::Real apply( core::pose::Pose& ) const;
private:
	core::scoring::ScoreFunctionOP scorefxn_;
	ResidueSelectionVector selection_;
	mutable ResidueSelectionVector exclude_list_;
	mutable Size nres_;
};

}
}

#endif
