// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file relax_initialization_protocols
/// @brief initialization protocols for relax
/// @detailed
///	  Contains currently: Classic Abinitio
///
///
/// @author Oliver Lange



#ifndef INCLUDED_protocols_evaluation_util_HH
#define INCLUDED_protocols_evaluation_util_HH


// Unit Headers
#include <protocols/evaluation/PoseEvaluator.fwd.hh>

// Package Headers

// Project Headers
#include <core/io/silent/silent.fwd.hh>
#include <core/pose/Pose.fwd.hh>

// ObjexxFCL Headers

// Utility headers
#include <utility/pointer/ReferenceCount.hh>
#include <utility/vector1.hh>

//// C++ headers
#include <list>
// due to template function
#include <core/io/silent/SilentStruct.hh>

namespace protocols {
namespace evaluation {


void read_common_evaluator_options( MetaPoseEvaluator& );

//@detail find residues that don't have missing density
typedef std::list< core::Size > ResidueSelection;
typedef utility::vector1< core::Size > ResidueSelectionVector;
void find_existing_residues(  core::pose::PoseCOP pose, std::string tag, ResidueSelection& selection );
void invert_include_residues( core::Size nres, ResidueSelectionVector const& include_list, ResidueSelectionVector& exclude_list );
void evaluate_pose( core::pose::Pose& pose, PoseEvaluator& eval, std::ostream& );

}
}
#endif
