// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author Nobuyasu Koga

#ifndef INCLUDED_protocols_flxbb_BluePrint_HH
#define INCLUDED_protocols_flxbb_BluePrint_HH

#include <core/scoring/SS_Info.hh>
#include <utility/pointer/ReferenceCount.hh>
#include <utility/vector1.hh>
#include <core/types.hh>
#include <string>
#include <iostream>

using namespace core;
////////////////////////////////////////////////////////////////////////////////////////////////////////////////

namespace protocols {
namespace flxbb {

  class BetaPair : public utility::pointer::ReferenceCount {

    friend class BluePrint;

  public:
    BetaPair( Size i, Size j, Real r, bool p ):
      strandi_( i ), strandj_( j ), rshift_( r ), parallel_( p ){}

    Size
    strandi() const
    {
      return strandi_;
    }

    Size
    strandj() const
    {
      return strandj_;
    }

    Real
    rshift() const
    {
      return rshift_;
    }

    bool
    parallel() const
    {
      return parallel_;
    }

    void
    set_strandi( Size const & value ){
      strandi_ = value;
    }

    void
    set_strandj( Size const & value ){
      strandi_ = value;
    }

    void
    set_rshift( Real const & value ){
      rshift_ = value;
    }

    void
    set_parallel( bool const & value ){
      parallel_ = value;
    }

    std::vector< std::vector< Size > >
    pair_res() const
    {
      return pair_res_;
    }

  private:

    Size strandi_;
    Size strandj_;
    Real rshift_;
    bool parallel_;
    std::vector< std::vector< Size > > pair_res_;

  }; // BetaPair

  typedef utility::pointer::owning_ptr< BetaPair > BetaPairOP;
  typedef utility::vector1< BetaPairOP > BetaPairings;

  ////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  class BluePrint : public utility::pointer::ReferenceCount {

  public:
    BluePrint():total_residue_( 0 ){}
    BluePrint( std::string const & filename );

    bool read_blueprint( std:: string const & );
    void identify_ss();
    void set_respairing();

    Size
    total_residue() const
    {
      return total_residue_;
    }

    std::string
    sequence() const
    {
      return sequence_;
    }

    char
    sequence( core::Size seqpos ) const
    {

      assert( seqpos >= 1 );
      return resname_[ seqpos ];
    }

    std::string
    secstruct() const
    {
      return secstruct_;
    }

    char
    secstruct( core::Size seqpos ) const
    {
      assert( seqpos >= 1 );
      return sstype_[ seqpos ];
    }

    BetaPairings
    beta_pairings() const
    {
      return beta_pairings_;
    }

    scoring::Strands
    strands() const
    {
      return strands_;
    }

    scoring::Helices
    helices() const
    {
      return helices_;
    }



  private:

    Size total_residue_;
    std::string sequence_;
    std::string secstruct_;
    utility::vector1< Size > resnum_;
    utility::vector1< char > resname_;
    utility::vector1< char > sstype_;

    BetaPairings beta_pairings_;

    core::scoring::Strands strands_;
    core::scoring::Helices helices_;

  }; //BluePrint

  typedef utility::pointer::owning_ptr< BluePrint > BluePrintOP;
}
}

#endif
