// -*- mode:c++;tab-width:2;indent-tabs-mode:t;show-trailing-whitespace:t;rm-trailing-spaces:t -*-
// vi: set ts=2 noet:
//
// (c) Copyright Rosetta Commons Member Institutions.
// (c) This file is part of the Rosetta software suite and is made available under license.
// (c) The Rosetta software is developed by the contributing members of the Rosetta Commons.
// (c) For more information, see http://www.rosettacommons.org. Questions about this can be
// (c) addressed to University of Washington UW TechTransfer, email: license@u.washington.edu.

/// @file
/// @brief
/// @author Nobuyasu Koga

#include <protocols/flxbb/FilterStructs.hh>

//Project
#include <core/pose/Pose.hh>
#include <core/scoring/packstat/compute_sasa.hh>

// Utility
#include <core/util/Tracer.hh>
using core::util::T;
using core::util::Error;
using core::util::Warning;

static core::util::Tracer TR("protocols.flxbb.FilterStructs");


using namespace core;
using namespace protocols::flxbb;

////////////////////////////////////////////////////////////////////////////////////////////////////////////
FilterStructs::~FilterStructs() {}
////////////////////////////////////////////////////////////////////////////////////////////////////////////
FilterStructs_Packstat::~FilterStructs_Packstat() {}

FilterStructsOP
FilterStructs_Packstat::clone() const
{
	return new FilterStructs_Packstat( *this );
}

void
FilterStructs_Packstat::apply( pose::Pose & pose ){

	using namespace core::scoring::packstat;

	ntrial_ --;
	Real packscore;
	packscore = compute_packing_score( pose );
	if (  packscore > best_packscore_ ) {
		best_pose_ = pose;
		best_packscore_ = packscore;
		TR << " Packscore : " << best_packscore_ << std::endl;
	}

	if( ntrial_ <= 0 ){
		set_filter_off();
		TR << " Packscore : " << best_packscore_ << std::endl;
	}

}



////////////////////////////////////////////////////////////////////////////////////////////////////////////
void
FilterStructs_TotalCharge::apply( pose::Pose & pose ){

	ntrial_ -- ;

	Real total_charge( 0.0 );
	for( Size i=1; i<=pose.total_residue(); ++i){

		chemical::AA aa =	pose.aa(	i	 );

		if( aa == chemical::aa_from_name( "GLU" ) ){
			total_charge -= 1.0;
		}else if( aa == chemical::aa_from_name( "ASP" ) ){
			total_charge -= 1.0;
		}else if( aa == chemical::aa_from_name( "ARG" ) ){
			total_charge += 1.0;
		}else if( aa == chemical::aa_from_name( "LYS" ) ){
			total_charge += 1.0;
		}
	}

	if( total_charge >= 1.0 || total_charge <= -1.0 || ntrial_ < 1 ){
		set_filter_off();
		best_pose_ = pose;
		TR << " Total charge : " << total_charge << std::endl;
	}

}

FilterStructs_TotalCharge::~FilterStructs_TotalCharge() {}

FilterStructsOP FilterStructs_TotalCharge::clone() const
{
	return new FilterStructs_TotalCharge( *this );

}

